/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GLException;

public class GLStateTracker {
    private static final boolean DEBUG = Debug.debug("GLStateTracker");
    private boolean enabled = true;
    private Map pixelStateMap = new HashMap();
    private List stack = new ArrayList();
    private static final Integer GL_PACK_SWAP_BYTES = new Integer(3328);
    private static final Integer GL_PACK_LSB_FIRST = new Integer(3329);
    private static final Integer GL_PACK_ROW_LENGTH = new Integer(3330);
    private static final Integer GL_PACK_SKIP_ROWS = new Integer(3331);
    private static final Integer GL_PACK_SKIP_PIXELS = new Integer(3332);
    private static final Integer GL_PACK_ALIGNMENT = new Integer(3333);
    private static final Integer GL_PACK_IMAGE_HEIGHT = new Integer(32876);
    private static final Integer GL_PACK_SKIP_IMAGES = new Integer(32875);
    private static final Integer GL_UNPACK_SWAP_BYTES = new Integer(3312);
    private static final Integer GL_UNPACK_LSB_FIRST = new Integer(3313);
    private static final Integer GL_UNPACK_ROW_LENGTH = new Integer(3314);
    private static final Integer GL_UNPACK_SKIP_ROWS = new Integer(3315);
    private static final Integer GL_UNPACK_SKIP_PIXELS = new Integer(3316);
    private static final Integer GL_UNPACK_ALIGNMENT = new Integer(3317);
    private static final Integer GL_UNPACK_IMAGE_HEIGHT = new Integer(32878);
    private static final Integer GL_UNPACK_SKIP_IMAGES = new Integer(32877);
    private static final Integer zero = new Integer(0);
    private static final Integer one = new Integer(1);

    public GLStateTracker() {
        this.resetStates();
    }

    public void clearStates() {
        this.pixelStateMap.clear();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getInt(int n, int[] nArray, int n2) {
        Integer n3;
        if (this.enabled && null != (n3 = GLStateTracker.boxKey(n))) {
            nArray[n2] = (Integer)this.pixelStateMap.get(n3);
            return true;
        }
        return false;
    }

    public boolean getInt(int n, IntBuffer intBuffer, int n2) {
        Integer n3;
        if (this.enabled && null != (n3 = GLStateTracker.boxKey(n))) {
            intBuffer.put(intBuffer.position(), (Integer)this.pixelStateMap.get(n3));
            return true;
        }
        return false;
    }

    public void setInt(int n, int n2) {
        Integer n3;
        if (this.enabled && null != (n3 = GLStateTracker.boxKey(n))) {
            this.pixelStateMap.put(n3, GLStateTracker.boxInt(n2));
        }
    }

    public void pushAttrib(int n) {
        if (this.enabled) {
            SavedState savedState = new SavedState();
            if (0 != (n & 1)) {
                savedState.putPixelStateMap(this.pixelStateMap);
            }
            this.stack.add(0, savedState);
        }
    }

    public void popAttrib() {
        if (this.enabled) {
            if (this.stack.size() == 0) {
                throw new GLException("stack contains no elements");
            }
            SavedState savedState = (SavedState)this.stack.remove(0);
            if (null == savedState) {
                throw new GLException("null stack element (remaining stack size " + this.stack.size() + ")");
            }
            this.clearStates();
            if (null != savedState.getPixelStateMap()) {
                this.pixelStateMap.putAll(savedState.getPixelStateMap());
            }
        }
    }

    private static Integer boxKey(int n) {
        switch (n) {
            case 0: {
                return zero;
            }
            case 3328: {
                return GL_PACK_SWAP_BYTES;
            }
            case 3329: {
                return GL_PACK_LSB_FIRST;
            }
            case 3330: {
                return GL_PACK_ROW_LENGTH;
            }
            case 3331: {
                return GL_PACK_SKIP_ROWS;
            }
            case 3332: {
                return GL_PACK_SKIP_PIXELS;
            }
            case 3333: {
                return GL_PACK_ALIGNMENT;
            }
            case 32876: {
                return GL_PACK_IMAGE_HEIGHT;
            }
            case 32875: {
                return GL_PACK_SKIP_IMAGES;
            }
            case 3312: {
                return GL_UNPACK_SWAP_BYTES;
            }
            case 3313: {
                return GL_UNPACK_LSB_FIRST;
            }
            case 3314: {
                return GL_UNPACK_ROW_LENGTH;
            }
            case 3315: {
                return GL_UNPACK_SKIP_ROWS;
            }
            case 3316: {
                return GL_UNPACK_SKIP_PIXELS;
            }
            case 3317: {
                return GL_UNPACK_ALIGNMENT;
            }
            case 32878: {
                return GL_UNPACK_IMAGE_HEIGHT;
            }
            case 32877: {
                return GL_UNPACK_SKIP_IMAGES;
            }
        }
        return null;
    }

    public void resetStates() {
        this.pixelStateMap.clear();
        this.pixelStateMap.put(GL_PACK_SWAP_BYTES, zero);
        this.pixelStateMap.put(GL_PACK_LSB_FIRST, zero);
        this.pixelStateMap.put(GL_PACK_ROW_LENGTH, zero);
        this.pixelStateMap.put(GL_PACK_SKIP_ROWS, zero);
        this.pixelStateMap.put(GL_PACK_SKIP_PIXELS, zero);
        this.pixelStateMap.put(GL_PACK_ALIGNMENT, new Integer(4));
        this.pixelStateMap.put(GL_PACK_IMAGE_HEIGHT, zero);
        this.pixelStateMap.put(GL_PACK_SKIP_IMAGES, zero);
        this.pixelStateMap.put(GL_UNPACK_SWAP_BYTES, zero);
        this.pixelStateMap.put(GL_UNPACK_LSB_FIRST, zero);
        this.pixelStateMap.put(GL_UNPACK_ROW_LENGTH, zero);
        this.pixelStateMap.put(GL_UNPACK_SKIP_ROWS, zero);
        this.pixelStateMap.put(GL_UNPACK_SKIP_PIXELS, zero);
        this.pixelStateMap.put(GL_UNPACK_ALIGNMENT, new Integer(4));
        this.pixelStateMap.put(GL_UNPACK_IMAGE_HEIGHT, zero);
        this.pixelStateMap.put(GL_UNPACK_SKIP_IMAGES, zero);
    }

    private static Integer boxInt(int n) {
        switch (n) {
            case 0: {
                return zero;
            }
            case 1: {
                return one;
            }
        }
        return new Integer(n);
    }

    static class SavedState {
        private Map pixelStateMap = null;

        SavedState() {
        }

        void putPixelStateMap(Map map) {
            this.pixelStateMap = new HashMap();
            this.pixelStateMap.putAll(map);
        }

        Map getPixelStateMap() {
            return this.pixelStateMap;
        }
    }
}

