/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.nativewindow.impl.NWReflection;
import com.sun.nativewindow.impl.jvm.JVMUtil;
import com.sun.opengl.impl.DRIHack;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.egl.EGLDynamicLookupHelper;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class GLProfile
implements Cloneable {
    public static final boolean DEBUG;
    public static final String GL3bc = "GL3bc";
    public static final String GL3 = "GL3";
    public static final String GL2 = "GL2";
    public static final String GLES1 = "GLES1";
    public static final String GLES2 = "GLES2";
    public static final String GL2ES1 = "GL2ES1";
    public static final String GL2ES2 = "GL2ES2";
    public static final String GL2GL3 = "GL2GL3";
    public static final String[] GL_PROFILE_LIST_ALL;
    public static final String[] GL_PROFILE_LIST_GL2ES2;
    public static final String[] GL_PROFILE_LIST_GL2ES1;
    private static final String GL2ES12 = "GL2ES12";
    private static final boolean isAWTAvailable;
    private static final boolean isAWTJOGLAvailable;
    private static final boolean hasGL3bcImpl;
    private static final boolean hasGL3Impl;
    private static final boolean hasGL2Impl;
    private static final boolean hasGL2ES12Impl;
    private static final boolean hasGLES2Impl;
    private static final boolean hasGLES1Impl;
    private static GLProfile defaultGLProfile;
    private static final HashMap mappedProfiles;
    private String profileImpl = null;
    private String profile = null;

    public static final GLProfile getDefault() {
        if (null == defaultGLProfile) {
            throw new GLException("No default profile available");
        }
        return defaultGLProfile;
    }

    public static final GLProfile get(String string) throws GLException {
        if (null == string || string.equals("GL")) {
            return GLProfile.getDefault();
        }
        GLProfile gLProfile = (GLProfile)mappedProfiles.get(string);
        if (null == gLProfile) {
            throw new GLException("No implementation for profile " + string + " available");
        }
        return gLProfile;
    }

    public static final GLProfile getGL2ES1() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_GL2ES1);
    }

    public static final GLProfile getGL2ES2() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_GL2ES2);
    }

    public static final GLProfile get(String[] stringArray) throws GLException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            GLProfile gLProfile = (GLProfile)mappedProfiles.get(string);
            if (null == gLProfile) continue;
            return gLProfile;
        }
        throw new GLException("Profiles " + GLProfile.list2String(stringArray) + " not available");
    }

    public static final boolean usesNativeGLES1(String string) {
        return GLES1.equals(string);
    }

    public static final boolean usesNativeGLES2(String string) {
        return GLES2.equals(string);
    }

    public static final boolean usesNativeGLES(String string) {
        return GLProfile.usesNativeGLES2(string) || GLProfile.usesNativeGLES1(string);
    }

    private static final String getGLImplBaseClassName(String string) {
        if (GL3bc.equals(string)) {
            return "com.sun.opengl.impl.gl3.GL3bc";
        }
        if (GL3.equals(string)) {
            return "com.sun.opengl.impl.gl3.GL3";
        }
        if (GL2.equals(string)) {
            return "com.sun.opengl.impl.gl2.GL2";
        }
        if (GL2ES12.equals(string)) {
            return "com.sun.opengl.impl.gl2es12.GL2ES12";
        }
        if (GLES1.equals(string) || GL2ES1.equals(string)) {
            return "com.sun.opengl.impl.es1.GLES1";
        }
        if (GLES2.equals(string) || GL2ES2.equals(string)) {
            return "com.sun.opengl.impl.es2.GLES2";
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    public final String getGLImplBaseClassName() {
        return GLProfile.getGLImplBaseClassName(this.profileImpl);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new GLException(exception);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof GLProfile) {
            GLProfile gLProfile = (GLProfile)object;
            return this.profile.equals(gLProfile.getName()) && this.profileImpl.equals(gLProfile.getImplName());
        }
        return false;
    }

    public final void verifyEquality(GLProfile gLProfile) throws GLException {
        if (!this.equals(gLProfile)) {
            throw new GLException("GLProfiles are not equal: " + this + " != " + gLProfile);
        }
    }

    public final String getName() {
        return this.profile;
    }

    public final String getImplName() {
        return this.profileImpl;
    }

    public final boolean isGL3bc() {
        return GL3bc.equals(this.profile);
    }

    public final boolean isGL3() {
        return this.isGL3bc() || GL3.equals(this.profile);
    }

    public final boolean isGL2() {
        return GL2.equals(this.profile);
    }

    public final boolean isGLES1() {
        return GLES1.equals(this.profile);
    }

    public final boolean isGLES2() {
        return GLES2.equals(this.profile);
    }

    public final boolean isGL2ES1() {
        return GL2ES1.equals(this.profile) || this.isGL2() || this.isGLES1();
    }

    public final boolean isGL2ES2() {
        return GL2ES2.equals(this.profile) || this.isGL2() || this.isGL3() || this.isGLES2();
    }

    public final boolean isGL2GL3() {
        return GL2GL3.equals(this.profile) || this.isGL2() || this.isGL3();
    }

    public final boolean usesNativeGLES1() {
        return GLES1.equals(this.profileImpl);
    }

    public final boolean usesNativeGLES2() {
        return GLES2.equals(this.profileImpl);
    }

    public final boolean usesNativeGLES() {
        return this.usesNativeGLES2() || this.usesNativeGLES1();
    }

    public final boolean usesNativeGL2() {
        return GL2.equals(this.profileImpl) || GL2ES12.equals(this.profileImpl);
    }

    public final boolean usesNativeGL3bc() {
        return GL3bc.equals(this.profileImpl);
    }

    public final boolean usesNativeGL3() {
        return this.usesNativeGL3bc() || GL3.equals(this.profileImpl);
    }

    public final boolean usesNativeGL2GL3() {
        return this.usesNativeGL2() || this.usesNativeGL3();
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public boolean isValidDataType(int n, boolean bl) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5126: 
            case 5132: {
                return true;
            }
            case 5124: 
            case 5125: {
                if (this.isGL2ES2()) {
                    return true;
                }
            }
            case 5130: {
                if (this.isGL3()) {
                    return true;
                }
            }
            case 5127: 
            case 5128: 
            case 5129: {
                if (!this.isGL2()) break;
                return true;
            }
        }
        if (bl) {
            throw new GLException("Illegal data type on profile " + this + ": " + n);
        }
        return false;
    }

    public boolean isValidArrayDataType(int n, int n2, int n3, boolean bl, boolean bl2) {
        block86: {
            String string;
            block88: {
                block87: {
                    block85: {
                        string = GLProfile.getGLArrayName(n);
                        if (!this.isGLES1()) break block85;
                        if (bl) {
                            if (bl2) {
                                throw new GLException("Illegal array type for " + string + " on profile GLES1: VertexAttribPointer");
                            }
                            return false;
                        }
                        block0 : switch (n) {
                            case 32884: 
                            case 32888: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32885: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 3: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32886: {
                                switch (n3) {
                                    case 5121: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                        }
                        break block86;
                    }
                    if (!this.isGLES2()) break block87;
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5126: 
                        case 5132: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GLES2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block86;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                            }
                            return false;
                        }
                    }
                }
                if (!this.isGL2ES2()) break block86;
                if (!bl) break block88;
                switch (n3) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 5130: {
                        break;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                        }
                        return false;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break block86;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                        }
                        return false;
                    }
                }
            }
            block35 : switch (n) {
                case 32884: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32885: {
                    switch (n3) {
                        case 5120: 
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                    }
                    return false;
                }
                case 32886: {
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32888: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block35;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "GLProfile[" + this.profile + "/" + this.profileImpl + "]";
    }

    private static final String list2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String computeProfileImpl(String string) {
        if (GL2ES1.equals(string)) {
            if (hasGL2ES12Impl) {
                return GL2ES12;
            }
            if (hasGL2Impl) {
                return GL2;
            }
            if (hasGLES1Impl) {
                return GLES1;
            }
        } else if (GL2ES2.equals(string)) {
            if (hasGL2ES12Impl) {
                return GL2ES12;
            }
            if (hasGL2Impl) {
                return GL2;
            }
            if (hasGL3Impl) {
                return GL3;
            }
            if (hasGL3bcImpl) {
                return GL3bc;
            }
            if (hasGLES2Impl) {
                return GLES2;
            }
        } else {
            if (GL3bc.equals(string) && hasGL3bcImpl) {
                return GL3bc;
            }
            if (GL3.equals(string)) {
                if (hasGL3Impl) {
                    return GL3;
                }
                if (hasGL3bcImpl) {
                    return GL3bc;
                }
            } else {
                if (GL2.equals(string) && hasGL2Impl) {
                    return GL2;
                }
                if (GL2GL3.equals(string) && hasGL2Impl) {
                    return GL2;
                }
                if (GLES2.equals(string) && hasGLES2Impl) {
                    return GLES2;
                }
                if (GLES1.equals(string) && hasGLES1Impl) {
                    return GLES1;
                }
            }
        }
        return null;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static boolean isAWTJOGLAvailable() {
        return isAWTJOGLAvailable;
    }

    public static String getGLTypeName(int n) {
        switch (n) {
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5126: {
                return "GL_FLOAT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5124: {
                return "GL_INT";
            }
            case 5125: {
                return "GL_UNSIGNED_INT";
            }
            case 5130: {
                return "GL_DOUBLE";
            }
            case 5127: {
                return "GL_2_BYTES";
            }
            case 5128: {
                return "GL_3_BYTES";
            }
            case 5129: {
                return "GL_4_BYTES";
            }
        }
        return null;
    }

    public static String getGLArrayName(int n) {
        switch (n) {
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return null;
    }

    private GLProfile(String string, String string2) {
        this.profile = string;
        this.profileImpl = string2;
    }

    static {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            DEBUG = Debug.debug("GLProfile");
                            GL_PROFILE_LIST_ALL = new String[]{GL2, GL2ES2, GL2ES1, GLES2, GLES1, GL2GL3, GL3bc, GL3};
                            GL_PROFILE_LIST_GL2ES2 = new String[]{GL2ES2, GL2, GLES2, GL3bc, GL3};
                            GL_PROFILE_LIST_GL2ES1 = new String[]{GL2ES1, GL2, GLES1};
                            JVMUtil.initSingleton();
                            AccessControlContext accessControlContext = AccessController.getContext();
                            isAWTAvailable = !Debug.getBooleanProperty("java.awt.headless", true, accessControlContext) && NWReflection.isClassAvailable("java.awt.Component");
                            isAWTJOGLAvailable = isAWTAvailable && NWReflection.isClassAvailable("javax.media.nativewindow.awt.AWTGraphicsDevice") && NWReflection.isClassAvailable("javax.media.opengl.awt.GLCanvas");
                            bl6 = false;
                            bl5 = false;
                            bl4 = false;
                            try {
                                DRIHack.begin();
                                NativeLibLoader.loadGLDesktop();
                                DRIHack.end();
                                bl6 = true;
                            }
                            catch (Throwable throwable) {
                                if (!DEBUG) break block19;
                                System.err.println("GLProfile.static Desktop GL Library not available");
                                throwable.printStackTrace();
                            }
                        }
                        try {
                            DRIHack.begin();
                            NativeLibLoader.loadGLDesktopES12();
                            DRIHack.end();
                            bl5 = true;
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG) break block20;
                            System.err.println("GLProfile.static Desktop GL ES12 Library not available");
                            throwable.printStackTrace();
                        }
                    }
                    if (bl6 || bl5) {
                        try {
                            bl4 = null != GLDrawableFactory.getFactoryImpl(GL2);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG) break block21;
                            System.err.println("GLProfile.static - Native platform GLDrawable factory not available");
                            throwable.printStackTrace();
                        }
                    }
                }
                if (!bl4) {
                    bl5 = false;
                    bl6 = false;
                }
                hasGL3bcImpl = bl6 && NWReflection.isClassAvailable("com.sun.opengl.impl.gl3.GL3bcImpl");
                hasGL3Impl = bl6 && NWReflection.isClassAvailable("com.sun.opengl.impl.gl3.GL3Impl");
                hasGL2Impl = bl6 && NWReflection.isClassAvailable("com.sun.opengl.impl.gl2.GL2Impl");
                hasGL2ES12Impl = bl5 && NWReflection.isClassAvailable("com.sun.opengl.impl.gl2es12.GL2ES12Impl");
                bl3 = false;
                bl2 = NWReflection.isClassAvailable("com.sun.opengl.impl.egl.EGLDynamicLookupHelper");
                bl = false;
                try {
                    if (bl2) {
                        bl = null != GLDrawableFactory.getFactoryImpl(GLES2);
                        bl3 = bl && NWReflection.isClassAvailable("com.sun.opengl.impl.es2.GLES2Impl") && null != EGLDynamicLookupHelper.getDynamicLookupHelper((int)2);
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block22;
                    System.err.println("GLProfile.static - GL ES2 Factory/Library not available");
                    throwable.printStackTrace();
                }
            }
            hasGLES2Impl = bl3;
            bl3 = false;
            try {
                if (bl2) {
                    bl3 = bl && NWReflection.isClassAvailable("com.sun.opengl.impl.es1.GLES1Impl") && null != EGLDynamicLookupHelper.getDynamicLookupHelper((int)1);
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block23;
                System.err.println("GLProfile.static - GL ES1 Factory/Library not available");
                throwable.printStackTrace();
            }
        }
        hasGLES1Impl = bl3;
        if (DEBUG) {
            System.err.println("GLProfile.static isAWTAvailable " + isAWTAvailable);
            System.err.println("GLProfile.static isAWTJOGLAvailable " + isAWTJOGLAvailable);
            System.err.println("GLProfile.static hasNativeOSFactory " + bl4);
            System.err.println("GLProfile.static hasDesktopGLES12 " + bl5);
            System.err.println("GLProfile.static hasDesktopGL " + bl6);
            System.err.println("GLProfile.static hasGL3bcImpl " + hasGL3bcImpl);
            System.err.println("GLProfile.static hasGL3Impl " + hasGL3Impl);
            System.err.println("GLProfile.static hasGL2Impl " + hasGL2Impl);
            System.err.println("GLProfile.static hasGL2ES12Impl " + hasGL2ES12Impl);
            System.err.println("GLProfile.static hasEGLDynLookup " + bl2);
            System.err.println("GLProfile.static hasEGLDrawableFactory " + bl);
            System.err.println("GLProfile.static hasGLES2Impl " + hasGLES2Impl);
            System.err.println("GLProfile.static hasGLES1Impl " + hasGLES1Impl);
        }
        HashMap<String, GLProfile> hashMap = new HashMap<String, GLProfile>(GL_PROFILE_LIST_ALL.length);
        for (int i = 0; i < GL_PROFILE_LIST_ALL.length; ++i) {
            String string = GL_PROFILE_LIST_ALL[i];
            String string2 = GLProfile.computeProfileImpl(string);
            if (null != string2) {
                GLProfile gLProfile = new GLProfile(string, string2);
                hashMap.put(string, gLProfile);
                if (DEBUG) {
                    System.err.println("GLProfile.static map " + gLProfile);
                }
                if (null != defaultGLProfile) continue;
                defaultGLProfile = gLProfile;
                if (!DEBUG) continue;
                System.err.println("GLProfile.static default " + gLProfile);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("GLProfile.static map *** no mapping for " + string);
        }
        mappedProfiles = hashMap;
        if (null == defaultGLProfile) {
            throw new GLException("No profile available: " + GLProfile.list2String(GL_PROFILE_LIST_ALL));
        }
    }
}

