/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.glu.gl2es1;

import com.sun.nativewindow.impl.NWReflection;
import com.sun.opengl.impl.InternalBufferUtil;
import com.sun.opengl.impl.glu.mipmap.Mipmap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES1;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class GLUgl2es1
extends GLU {
    protected static boolean availableMipmap = false;
    protected static boolean checkedMipmap = false;

    public void destroy() {
        super.destroy();
    }

    public static final GL2ES1 getCurrentGL2ES1() throws GLException {
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null) {
            throw new GLException("No OpenGL context current on this thread");
        }
        return gLContext.getGL().getGL2ES1();
    }

    protected static final void validateMipmap() {
        if (!checkedMipmap) {
            availableMipmap = NWReflection.isClassAvailable("com.sun.opengl.impl.glu.mipmap.Mipmap");
            checkedMipmap = true;
        }
        if (!availableMipmap) {
            throw new GLException("Mipmap not available");
        }
    }

    private final ByteBuffer copyToByteBuffer(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            if (buffer.position() == 0) {
                return (ByteBuffer)buffer;
            }
            return InternalBufferUtil.copyByteBuffer((ByteBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return InternalBufferUtil.copyShortBufferAsByteBuffer((ShortBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return InternalBufferUtil.copyIntBufferAsByteBuffer((IntBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return InternalBufferUtil.copyFloatBufferAsByteBuffer((FloatBuffer)buffer);
        }
        throw new IllegalArgumentException("Unsupported buffer type (must be one of byte, short, int, or float)");
    }

    public final int gluScaleImage(int n, int n2, int n3, int n4, Buffer buffer, int n5, int n6, int n7, Buffer buffer2) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        byteBuffer = this.copyToByteBuffer(buffer);
        if (buffer2 instanceof ByteBuffer) {
            byteBuffer2 = (ByteBuffer)buffer2;
        } else if (buffer2 instanceof ShortBuffer) {
            byteBuffer2 = InternalBufferUtil.newByteBuffer(buffer2.remaining() * 2);
        } else if (buffer2 instanceof IntBuffer) {
            byteBuffer2 = InternalBufferUtil.newByteBuffer(buffer2.remaining() * 4);
        } else if (buffer2 instanceof FloatBuffer) {
            byteBuffer2 = InternalBufferUtil.newByteBuffer(buffer2.remaining() * 4);
        } else {
            throw new IllegalArgumentException("Unsupported destination buffer type (must be byte, short, int, or float)");
        }
        int n8 = Mipmap.gluScaleImage((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (ByteBuffer)byteBuffer, (int)n5, (int)n6, (int)n7, (ByteBuffer)byteBuffer2);
        if (n8 == 0) {
            byteBuffer2.rewind();
            if (byteBuffer2 != buffer2) {
                if (buffer2 instanceof ShortBuffer) {
                    ((ShortBuffer)buffer2).put(byteBuffer2.asShortBuffer());
                } else if (buffer2 instanceof IntBuffer) {
                    ((IntBuffer)buffer2).put(byteBuffer2.asIntBuffer());
                } else if (buffer2 instanceof FloatBuffer) {
                    ((FloatBuffer)buffer2).put(byteBuffer2.asFloatBuffer());
                } else {
                    throw new RuntimeException("Should not reach here");
                }
            }
        }
        return n8;
    }

    public final int gluBuild1DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild1DMipmapLevels((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (ByteBuffer)byteBuffer);
    }

    public final int gluBuild1DMipmaps(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild1DMipmaps((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (ByteBuffer)byteBuffer);
    }

    public final int gluBuild2DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        buffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild2DMipmapLevels((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (Object)buffer);
    }

    public final int gluBuild2DMipmaps(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        buffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild2DMipmaps((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (Object)buffer);
    }

    public final int gluBuild3DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild3DMipmapLevels((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (ByteBuffer)byteBuffer);
    }

    public final int gluBuild3DMipmaps(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild3DMipmaps((GL)GLUgl2es1.getCurrentGL2ES1(), (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (ByteBuffer)byteBuffer);
    }
}

