/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.Expression;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.DefaultExtensionFactory;
import ro.fortsoft.pf4j.DefaultExtensionFinder;
import ro.fortsoft.pf4j.DefaultPluginDescriptorFinder;
import ro.fortsoft.pf4j.DefaultPluginFactory;
import ro.fortsoft.pf4j.DefaultPluginRepository;
import ro.fortsoft.pf4j.DefaultPluginStatusProvider;
import ro.fortsoft.pf4j.DependencyResolver;
import ro.fortsoft.pf4j.DevelopmentPluginClasspath;
import ro.fortsoft.pf4j.ExtensionFactory;
import ro.fortsoft.pf4j.ExtensionFinder;
import ro.fortsoft.pf4j.ExtensionWrapper;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginClasspath;
import ro.fortsoft.pf4j.PluginDependency;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.PluginFactory;
import ro.fortsoft.pf4j.PluginLoader;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginRepository;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginStateEvent;
import ro.fortsoft.pf4j.PluginStateListener;
import ro.fortsoft.pf4j.PluginStatusProvider;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.PropertiesPluginDescriptorFinder;
import ro.fortsoft.pf4j.RuntimeMode;
import ro.fortsoft.pf4j.util.AndFileFilter;
import ro.fortsoft.pf4j.util.DirectoryFileFilter;
import ro.fortsoft.pf4j.util.FileUtils;
import ro.fortsoft.pf4j.util.HiddenFilter;
import ro.fortsoft.pf4j.util.NameFileFilter;
import ro.fortsoft.pf4j.util.NotFileFilter;
import ro.fortsoft.pf4j.util.OrFileFilter;
import ro.fortsoft.pf4j.util.Unzip;
import ro.fortsoft.pf4j.util.ZipFileFilter;

public class DefaultPluginManager
implements PluginManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginManager.class);
    public static final String DEFAULT_PLUGINS_DIRECTORY = "plugins";
    public static final String DEVELOPMENT_PLUGINS_DIRECTORY = "../plugins";
    protected File pluginsDirectory;
    protected ExtensionFinder extensionFinder;
    protected PluginDescriptorFinder pluginDescriptorFinder;
    protected PluginClasspath pluginClasspath;
    protected Map<String, PluginWrapper> plugins;
    protected Map<String, PluginClassLoader> pluginClassLoaders;
    protected Map<String, String> pathToIdMap;
    protected List<PluginWrapper> unresolvedPlugins;
    protected List<PluginWrapper> resolvedPlugins;
    protected List<PluginWrapper> startedPlugins;
    protected List<PluginStateListener> pluginStateListeners;
    protected RuntimeMode runtimeMode;
    protected Version systemVersion = Version.forIntegers((int)0, (int)0, (int)0);
    protected PluginFactory pluginFactory;
    protected ExtensionFactory extensionFactory;
    protected PluginStatusProvider pluginStatusProvider;
    protected DependencyResolver dependencyResolver;
    protected PluginRepository pluginRepository;

    public DefaultPluginManager() {
        this.pluginsDirectory = this.createPluginsDirectory();
        this.initialize();
    }

    public DefaultPluginManager(File pluginsDirectory) {
        this.pluginsDirectory = pluginsDirectory;
        this.initialize();
    }

    @Override
    public void setSystemVersion(Version version) {
        this.systemVersion = version;
    }

    @Override
    public Version getSystemVersion() {
        return this.systemVersion;
    }

    @Override
    public List<PluginWrapper> getPlugins() {
        return new ArrayList<PluginWrapper>(this.plugins.values());
    }

    @Override
    public List<PluginWrapper> getPlugins(PluginState pluginState) {
        ArrayList<PluginWrapper> plugins = new ArrayList<PluginWrapper>();
        for (PluginWrapper plugin : this.getPlugins()) {
            if (!pluginState.equals(plugin.getPluginState())) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    @Override
    public List<PluginWrapper> getResolvedPlugins() {
        return this.resolvedPlugins;
    }

    @Override
    public List<PluginWrapper> getUnresolvedPlugins() {
        return this.unresolvedPlugins;
    }

    @Override
    public List<PluginWrapper> getStartedPlugins() {
        return this.startedPlugins;
    }

    @Override
    public PluginWrapper getPlugin(String pluginId) {
        return this.plugins.get(pluginId);
    }

    @Override
    public String loadPlugin(File pluginArchiveFile) {
        if (pluginArchiveFile == null || !pluginArchiveFile.exists()) {
            throw new IllegalArgumentException(String.format("Specified plugin %s does not exist!", pluginArchiveFile));
        }
        log.debug("Loading plugin from '{}'", (Object)pluginArchiveFile);
        File pluginDirectory = null;
        try {
            pluginDirectory = this.expandPluginArchive(pluginArchiveFile);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (pluginDirectory == null || !pluginDirectory.exists()) {
            throw new IllegalArgumentException(String.format("Failed to expand %s", pluginArchiveFile));
        }
        try {
            PluginWrapper pluginWrapper = this.loadPluginDirectory(pluginDirectory);
            this.unresolvedPlugins.remove(pluginWrapper);
            this.resolvedPlugins.add(pluginWrapper);
            this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, null));
            return pluginWrapper.getDescriptor().getPluginId();
        }
        catch (PluginException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void startPlugins() {
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.DISABLED == pluginState || PluginState.STARTED == pluginState) continue;
            try {
                PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
                log.info("Start plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
                pluginWrapper.getPlugin().start();
                pluginWrapper.setPluginState(PluginState.STARTED);
                this.startedPlugins.add(pluginWrapper);
                this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
            }
            catch (PluginException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public PluginState startPlugin(String pluginId) {
        if (!this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException(String.format("Unknown pluginId %s", pluginId));
        }
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        PluginState pluginState = pluginWrapper.getPluginState();
        if (PluginState.STARTED == pluginState) {
            log.debug("Already started plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            return PluginState.STARTED;
        }
        if (PluginState.DISABLED == pluginState && !this.enablePlugin(pluginId)) {
            return pluginState;
        }
        for (PluginDependency dependency : pluginDescriptor.getDependencies()) {
            this.startPlugin(dependency.getPluginId());
        }
        try {
            log.info("Start plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            pluginWrapper.getPlugin().start();
            pluginWrapper.setPluginState(PluginState.STARTED);
            this.startedPlugins.add(pluginWrapper);
            this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
        }
        catch (PluginException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pluginWrapper.getPluginState();
    }

    @Override
    public void stopPlugins() {
        Collections.reverse(this.startedPlugins);
        Iterator<PluginWrapper> itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (PluginState.STARTED != pluginState) continue;
            try {
                PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
                log.info("Stop plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
                pluginWrapper.getPlugin().stop();
                pluginWrapper.setPluginState(PluginState.STOPPED);
                itr.remove();
                this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
            }
            catch (PluginException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public PluginState stopPlugin(String pluginId) {
        return this.stopPlugin(pluginId, true);
    }

    private PluginState stopPlugin(String pluginId, boolean stopDependents) {
        if (!this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException(String.format("Unknown pluginId %s", pluginId));
        }
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        PluginState pluginState = pluginWrapper.getPluginState();
        if (PluginState.STOPPED == pluginState) {
            log.debug("Already stopped plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            return PluginState.STOPPED;
        }
        if (PluginState.DISABLED == pluginState) {
            return pluginState;
        }
        if (stopDependents) {
            List<String> dependents = this.dependencyResolver.getDependents(pluginId);
            while (!dependents.isEmpty()) {
                String dependent = dependents.remove(0);
                this.stopPlugin(dependent, false);
                dependents.addAll(0, this.dependencyResolver.getDependents(dependent));
            }
        }
        try {
            log.info("Stop plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            pluginWrapper.getPlugin().stop();
            pluginWrapper.setPluginState(PluginState.STOPPED);
            this.startedPlugins.remove(pluginWrapper);
            this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
        }
        catch (PluginException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return pluginWrapper.getPluginState();
    }

    @Override
    public void loadPlugins() {
        log.debug("Lookup plugins in '{}'", (Object)this.pluginsDirectory.getAbsolutePath());
        if (!this.pluginsDirectory.exists() || !this.pluginsDirectory.isDirectory()) {
            log.error("No '{}' directory", (Object)this.pluginsDirectory.getAbsolutePath());
            return;
        }
        List<File> pluginArchives = this.pluginRepository.getPluginArchives();
        for (File archiveFile : pluginArchives) {
            try {
                this.expandPluginArchive(archiveFile);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        AndFileFilter pluginsFilter = new AndFileFilter(new DirectoryFileFilter());
        pluginsFilter.addFileFilter(new NotFileFilter(this.createHiddenPluginFilter()));
        File[] directories = this.pluginsDirectory.listFiles(pluginsFilter);
        if (directories == null) {
            directories = new File[]{};
        }
        log.debug("Found {} possible plugins: {}", (Object)directories.length, (Object)directories);
        if (directories.length == 0) {
            log.info("No plugins");
            return;
        }
        for (File directory : directories) {
            try {
                this.loadPluginDirectory(directory);
            }
            catch (PluginException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.resolvePlugins();
        }
        catch (PluginException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean unloadPlugin(String pluginId) {
        try {
            PluginState pluginState = this.stopPlugin(pluginId);
            if (PluginState.STARTED == pluginState) {
                return false;
            }
            PluginWrapper pluginWrapper = this.getPlugin(pluginId);
            PluginDescriptor descriptor = pluginWrapper.getDescriptor();
            List<PluginDependency> dependencies = descriptor.getDependencies();
            for (PluginDependency dependency : dependencies) {
                if (this.unloadPlugin(dependency.getPluginId())) continue;
                return false;
            }
            this.plugins.remove(pluginId);
            this.resolvedPlugins.remove(pluginWrapper);
            this.pathToIdMap.remove(pluginWrapper.getPluginPath());
            this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
            if (this.pluginClassLoaders.containsKey(pluginId)) {
                PluginClassLoader classLoader = this.pluginClassLoaders.remove(pluginId);
                classLoader.dispose();
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public boolean disablePlugin(String pluginId) {
        if (!this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException(String.format("Unknown pluginId %s", pluginId));
        }
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        PluginState pluginState = pluginWrapper.getPluginState();
        if (PluginState.DISABLED == pluginState) {
            log.debug("Already disabled plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            return true;
        }
        if (PluginState.STOPPED == this.stopPlugin(pluginId)) {
            pluginWrapper.setPluginState(PluginState.DISABLED);
            this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, PluginState.STOPPED));
            if (!this.pluginStatusProvider.disablePlugin(pluginId)) {
                return false;
            }
            log.info("Disabled plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            return true;
        }
        return false;
    }

    @Override
    public boolean enablePlugin(String pluginId) {
        if (!this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException(String.format("Unknown pluginId %s", pluginId));
        }
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        if (!this.isPluginValid(pluginWrapper)) {
            log.warn("Plugin '{}:{}' can not be enabled", (Object)pluginWrapper.getPluginId(), (Object)pluginWrapper.getDescriptor().getVersion());
            return false;
        }
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        PluginState pluginState = pluginWrapper.getPluginState();
        if (PluginState.DISABLED != pluginState) {
            log.debug("Plugin '{}:{}' is not disabled", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
            return true;
        }
        if (!this.pluginStatusProvider.enablePlugin(pluginId)) {
            return false;
        }
        pluginWrapper.setPluginState(PluginState.CREATED);
        this.firePluginStateEvent(new PluginStateEvent(this, pluginWrapper, pluginState));
        log.info("Enabled plugin '{}:{}'", (Object)pluginDescriptor.getPluginId(), (Object)pluginDescriptor.getVersion());
        return true;
    }

    @Override
    public boolean deletePlugin(String pluginId) {
        if (!this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException(String.format("Unknown pluginId %s", pluginId));
        }
        PluginWrapper pluginWrapper = this.getPlugin(pluginId);
        PluginState pluginState = this.stopPlugin(pluginId);
        if (PluginState.STARTED == pluginState) {
            log.error("Failed to stop plugin {} on delete", (Object)pluginId);
            return false;
        }
        if (!this.unloadPlugin(pluginId)) {
            log.error("Failed to unload plugin {} on delete", (Object)pluginId);
            return false;
        }
        File pluginFolder = new File(this.pluginsDirectory, pluginWrapper.getPluginPath());
        if (pluginFolder.exists()) {
            FileUtils.delete(pluginFolder);
        }
        this.pluginRepository.deletePluginArchive(pluginWrapper.getPluginPath());
        return true;
    }

    @Override
    public PluginClassLoader getPluginClassLoader(String pluginId) {
        return this.pluginClassLoaders.get(pluginId);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> type) {
        List<ExtensionWrapper<T>> extensionsWrapper = this.extensionFinder.find(type);
        ArrayList<T> extensions = new ArrayList<T>(extensionsWrapper.size());
        for (ExtensionWrapper<T> extensionWrapper : extensionsWrapper) {
            extensions.add(extensionWrapper.getExtension());
        }
        return extensions;
    }

    @Override
    public <T> List<T> getExtensions(Class<T> type, String pluginId) {
        List<ExtensionWrapper<T>> extensionsWrapper = this.extensionFinder.find(type, pluginId);
        ArrayList<T> extensions = new ArrayList<T>(extensionsWrapper.size());
        for (ExtensionWrapper<T> extensionWrapper : extensionsWrapper) {
            extensions.add(extensionWrapper.getExtension());
        }
        return extensions;
    }

    @Override
    public List getExtensions(String pluginId) {
        List<ExtensionWrapper> extensionsWrapper = this.extensionFinder.find(pluginId);
        ArrayList extensions = new ArrayList(extensionsWrapper.size());
        for (ExtensionWrapper extensionWrapper : extensionsWrapper) {
            extensions.add(extensionWrapper.getExtension());
        }
        return extensions;
    }

    @Override
    public Set<String> getExtensionClassNames(String pluginId) {
        return this.extensionFinder.findClassNames(pluginId);
    }

    @Override
    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @Override
    public RuntimeMode getRuntimeMode() {
        if (this.runtimeMode == null) {
            String modeAsString = System.getProperty("pf4j.mode", RuntimeMode.DEPLOYMENT.toString());
            this.runtimeMode = RuntimeMode.byName(modeAsString);
        }
        return this.runtimeMode;
    }

    @Override
    public PluginWrapper whichPlugin(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        for (PluginWrapper plugin : this.resolvedPlugins) {
            if (plugin.getPluginClassLoader() != classLoader) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public synchronized void addPluginStateListener(PluginStateListener listener) {
        this.pluginStateListeners.add(listener);
    }

    @Override
    public synchronized void removePluginStateListener(PluginStateListener listener) {
        this.pluginStateListeners.remove(listener);
    }

    public Version getVersion() {
        String version = null;
        Package pf4jPackage = this.getClass().getPackage();
        if (pf4jPackage != null && (version = pf4jPackage.getImplementationVersion()) == null) {
            version = pf4jPackage.getSpecificationVersion();
        }
        return version != null ? Version.valueOf((String)version) : Version.forIntegers((int)0, (int)0, (int)0);
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        if (RuntimeMode.DEVELOPMENT.equals((Object)this.getRuntimeMode())) {
            return new PropertiesPluginDescriptorFinder();
        }
        return new DefaultPluginDescriptorFinder(this.pluginClasspath);
    }

    protected ExtensionFinder createExtensionFinder() {
        DefaultExtensionFinder extensionFinder = new DefaultExtensionFinder(this);
        this.addPluginStateListener(extensionFinder);
        return extensionFinder;
    }

    protected PluginClasspath createPluginClasspath() {
        if (RuntimeMode.DEVELOPMENT.equals((Object)this.getRuntimeMode())) {
            return new DevelopmentPluginClasspath();
        }
        return new PluginClasspath();
    }

    protected PluginStatusProvider createPluginStatusProvider() {
        return new DefaultPluginStatusProvider(this.pluginsDirectory);
    }

    protected PluginRepository createPluginRepository() {
        return new DefaultPluginRepository(this.pluginsDirectory, new ZipFileFilter());
    }

    protected boolean isPluginDisabled(String pluginId) {
        return this.pluginStatusProvider.isPluginDisabled(pluginId);
    }

    protected boolean isPluginValid(PluginWrapper pluginWrapper) {
        Version system;
        Expression requires = pluginWrapper.getDescriptor().getRequires();
        if (requires.interpret(system = this.getSystemVersion())) {
            return true;
        }
        log.warn("Plugin '{}:{}' requires a minimum system version of {}", new Object[]{pluginWrapper.getPluginId(), pluginWrapper.getDescriptor().getVersion(), requires});
        return false;
    }

    protected FileFilter createHiddenPluginFilter() {
        OrFileFilter hiddenPluginFilter = new OrFileFilter(new HiddenFilter());
        if (RuntimeMode.DEVELOPMENT.equals((Object)this.getRuntimeMode())) {
            hiddenPluginFilter.addFileFilter(new NameFileFilter("target"));
        }
        return hiddenPluginFilter;
    }

    protected File createPluginsDirectory() {
        String pluginsDir = System.getProperty("pf4j.pluginsDir");
        if (pluginsDir == null) {
            pluginsDir = RuntimeMode.DEVELOPMENT.equals((Object)this.getRuntimeMode()) ? DEVELOPMENT_PLUGINS_DIRECTORY : DEFAULT_PLUGINS_DIRECTORY;
        }
        return new File(pluginsDir);
    }

    protected PluginFactory createPluginFactory() {
        return new DefaultPluginFactory();
    }

    protected ExtensionFactory createExtensionFactory() {
        return new DefaultExtensionFactory();
    }

    protected PluginClassLoader createPluginClassLoader(PluginDescriptor pluginDescriptor) {
        return new PluginClassLoader(this, pluginDescriptor, this.getClass().getClassLoader());
    }

    private void initialize() {
        this.plugins = new HashMap<String, PluginWrapper>();
        this.pluginClassLoaders = new HashMap<String, PluginClassLoader>();
        this.pathToIdMap = new HashMap<String, String>();
        this.unresolvedPlugins = new ArrayList<PluginWrapper>();
        this.resolvedPlugins = new ArrayList<PluginWrapper>();
        this.startedPlugins = new ArrayList<PluginWrapper>();
        this.pluginStateListeners = new ArrayList<PluginStateListener>();
        this.dependencyResolver = new DependencyResolver();
        log.info("PF4J version {} in '{}' mode", (Object)this.getVersion(), (Object)this.getRuntimeMode());
        this.pluginClasspath = this.createPluginClasspath();
        this.pluginFactory = this.createPluginFactory();
        this.extensionFactory = this.createExtensionFactory();
        this.pluginDescriptorFinder = this.createPluginDescriptorFinder();
        this.extensionFinder = this.createExtensionFinder();
        this.pluginStatusProvider = this.createPluginStatusProvider();
        this.pluginRepository = this.createPluginRepository();
        try {
            this.pluginsDirectory = this.pluginsDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        System.setProperty("pf4j.pluginsDir", this.pluginsDirectory.getAbsolutePath());
    }

    private PluginWrapper loadPluginDirectory(File pluginDirectory) throws PluginException {
        String pluginName = pluginDirectory.getName();
        String pluginPath = "/".concat(pluginName);
        if (this.plugins.get(this.pathToIdMap.get(pluginPath)) != null) {
            return null;
        }
        log.debug("Find plugin descriptor '{}'", (Object)pluginPath);
        PluginDescriptor pluginDescriptor = this.pluginDescriptorFinder.find(pluginDirectory);
        log.debug("Descriptor " + pluginDescriptor);
        String pluginClassName = pluginDescriptor.getPluginClass();
        log.debug("Class '{}' for plugin '{}'", (Object)pluginClassName, (Object)pluginPath);
        log.debug("Loading plugin '{}'", (Object)pluginPath);
        PluginClassLoader pluginClassLoader = this.createPluginClassLoader(pluginDescriptor);
        log.debug("Created class loader '{}'", (Object)pluginClassLoader);
        PluginLoader pluginLoader = new PluginLoader(pluginDirectory, pluginClassLoader, this.pluginClasspath);
        pluginLoader.load();
        log.debug("Loaded plugin '{}'", (Object)pluginPath);
        log.debug("Creating wrapper for plugin '{}'", (Object)pluginPath);
        PluginWrapper pluginWrapper = new PluginWrapper(this, pluginDescriptor, pluginPath, pluginClassLoader);
        pluginWrapper.setPluginFactory(this.pluginFactory);
        pluginWrapper.setRuntimeMode(this.getRuntimeMode());
        if (this.isPluginDisabled(pluginDescriptor.getPluginId())) {
            log.info("Plugin '{}' is disabled", (Object)pluginPath);
            pluginWrapper.setPluginState(PluginState.DISABLED);
        }
        if (!this.isPluginValid(pluginWrapper)) {
            log.info("Plugin '{}' is disabled", (Object)pluginPath);
            pluginWrapper.setPluginState(PluginState.DISABLED);
        }
        log.debug("Created wrapper '{}' for plugin '{}'", (Object)pluginWrapper, (Object)pluginPath);
        String pluginId = pluginDescriptor.getPluginId();
        this.plugins.put(pluginId, pluginWrapper);
        this.unresolvedPlugins.add(pluginWrapper);
        this.pluginClassLoaders.put(pluginId, pluginClassLoader);
        return pluginWrapper;
    }

    private File expandPluginArchive(File pluginArchiveFile) throws IOException {
        String fileName = pluginArchiveFile.getName();
        long pluginArchiveDate = pluginArchiveFile.lastModified();
        String pluginName = fileName.substring(0, fileName.length() - 4);
        File pluginDirectory = new File(this.pluginsDirectory, pluginName);
        if (!pluginDirectory.exists() || pluginArchiveDate > pluginDirectory.lastModified()) {
            log.debug("Expand plugin archive '{}' in '{}'", (Object)pluginArchiveFile, (Object)pluginDirectory);
            if (pluginDirectory.exists()) {
                FileUtils.delete(pluginDirectory);
            }
            pluginDirectory.mkdirs();
            Unzip unzip = new Unzip();
            unzip.setSource(pluginArchiveFile);
            unzip.setDestination(pluginDirectory);
            unzip.extract();
        }
        return pluginDirectory;
    }

    private void resolvePlugins() throws PluginException {
        this.resolveDependencies();
    }

    private void resolveDependencies() throws PluginException {
        this.dependencyResolver.resolve(this.unresolvedPlugins);
        this.resolvedPlugins = this.dependencyResolver.getSortedPlugins();
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            this.unresolvedPlugins.remove(pluginWrapper);
            log.info("Plugin '{}' resolved", (Object)pluginWrapper.getDescriptor().getPluginId());
        }
    }

    private synchronized void firePluginStateEvent(PluginStateEvent event) {
        for (PluginStateListener listener : this.pluginStateListeners) {
            log.debug("Fire '{}' to '{}'", (Object)event, (Object)listener);
            listener.pluginStateChanged(event);
        }
    }
}

