/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginStatusProvider;
import ro.fortsoft.pf4j.util.FileUtils;

public class DefaultPluginStatusProvider
implements PluginStatusProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginStatusProvider.class);
    private final File pluginsDirectory;
    private List<String> enabledPlugins = new ArrayList<String>();
    private List<String> disabledPlugins = new ArrayList<String>();

    public DefaultPluginStatusProvider(File pluginsDirectory) {
        this.pluginsDirectory = pluginsDirectory;
        this.initialize();
    }

    private void initialize() {
        try {
            this.enabledPlugins = FileUtils.readLines(new File(this.pluginsDirectory, "enabled.txt"), true);
            log.info("Enabled plugins: {}", this.enabledPlugins);
            this.disabledPlugins = FileUtils.readLines(new File(this.pluginsDirectory, "disabled.txt"), true);
            log.info("Disabled plugins: {}", this.disabledPlugins);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enabledPlugins.isEmpty() && !this.enabledPlugins.contains(pluginId);
    }

    @Override
    public boolean disablePlugin(String pluginId) {
        if (this.disabledPlugins.add(pluginId)) {
            try {
                FileUtils.writeLines(this.disabledPlugins, new File(this.pluginsDirectory, "disabled.txt"));
            }
            catch (IOException e) {
                log.error("Failed to disable plugin {}", (Object)pluginId, (Object)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean enablePlugin(String pluginId) {
        try {
            if (this.disabledPlugins.remove(pluginId)) {
                FileUtils.writeLines(this.disabledPlugins, new File(this.pluginsDirectory, "disabled.txt"));
            }
        }
        catch (IOException e) {
            log.error("Failed to enable plugin {}", (Object)pluginId, (Object)e);
            return false;
        }
        return true;
    }
}

