/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginClasspath;
import ro.fortsoft.pf4j.util.DirectoryFileFilter;
import ro.fortsoft.pf4j.util.JarFileFilter;

class PluginLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginLoader.class);
    private File pluginRepository;
    private PluginClasspath pluginClasspath;
    private PluginClassLoader pluginClassLoader;

    public PluginLoader(File pluginRepository, PluginClassLoader pluginClassLoader, PluginClasspath pluginClasspath) {
        this.pluginRepository = pluginRepository;
        this.pluginClassLoader = pluginClassLoader;
        this.pluginClasspath = pluginClasspath;
    }

    public boolean load() {
        return this.loadClassesAndJars();
    }

    private boolean loadClassesAndJars() {
        return this.loadClasses() && this.loadJars();
    }

    private boolean loadClasses() {
        List<String> classesDirectories = this.pluginClasspath.getClassesDirectories();
        for (String classesDirectory : classesDirectories) {
            File file = new File(this.pluginRepository, classesDirectory).getAbsoluteFile();
            if (!file.exists() || !file.isDirectory()) continue;
            log.debug("Found '{}' directory", (Object)file.getPath());
            try {
                this.pluginClassLoader.addURL(file.toURI().toURL());
                log.debug("Added '{}' to the class loader path", (Object)file);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean loadJars() {
        List<String> libDirectories = this.pluginClasspath.getLibDirectories();
        for (String libDirectory : libDirectories) {
            File file = new File(this.pluginRepository, libDirectory).getAbsoluteFile();
            Vector<File> jars = new Vector<File>();
            this.getJars(jars, file);
            for (File jar : jars) {
                try {
                    this.pluginClassLoader.addURL(jar.toURI().toURL());
                    log.debug("Added '{}' to the class loader path", (Object)jar);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    log.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private void getJars(Vector<File> bucket, File file) {
        JarFileFilter jarFilter = new JarFileFilter();
        DirectoryFileFilter directoryFilter = new DirectoryFileFilter();
        if (file.exists() && file.isDirectory() && file.isAbsolute()) {
            File[] jars = file.listFiles(jarFilter);
            for (int i = 0; jars != null && i < jars.length; ++i) {
                bucket.addElement(jars[i]);
            }
            File[] directories = file.listFiles(directoryFilter);
            for (int i = 0; directories != null && i < directories.length; ++i) {
                File directory = directories[i];
                this.getJars(bucket, directory);
            }
        }
    }
}

