/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.AbstractExtensionFinder;
import ro.fortsoft.pf4j.PluginClassLoader;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.processor.ServiceProviderExtensionStorage;

public class ServiceProviderExtensionFinder
extends AbstractExtensionFinder {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderExtensionFinder.class);

    public ServiceProviderExtensionFinder(PluginManager pluginManager) {
        super(pluginManager);
    }

    @Override
    public Map<String, Set<String>> readClasspathStorages() {
        log.debug("Reading extensions storages from classpath");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        HashSet<String> bucket = new HashSet<String>();
        try {
            URL url = this.getClass().getClassLoader().getResource(ServiceProviderExtensionFinder.getExtensionsResource());
            if (url != null) {
                Path extensionPath;
                if (url.toURI().getScheme().equals("jar")) {
                    FileSystem fileSystem = FileSystems.newFileSystem(url.toURI(), Collections.emptyMap());
                    extensionPath = fileSystem.getPath(ServiceProviderExtensionFinder.getExtensionsResource(), new String[0]);
                } else {
                    extensionPath = Paths.get(url.toURI());
                }
                bucket.addAll(this.readExtensions(extensionPath));
            }
            this.debugExtensions(bucket);
            result.put(null, bucket);
        }
        catch (IOException | URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public Map<String, Set<String>> readPluginsStorages() {
        log.debug("Reading extensions storages from plugins");
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        List<PluginWrapper> plugins = this.pluginManager.getPlugins();
        for (PluginWrapper plugin : plugins) {
            String pluginId = plugin.getDescriptor().getPluginId();
            log.debug("Reading extensions storages for plugin '{}'", (Object)pluginId);
            HashSet<String> bucket = new HashSet<String>();
            try {
                URL url = ((PluginClassLoader)plugin.getPluginClassLoader()).findResource(ServiceProviderExtensionFinder.getExtensionsResource());
                if (url != null) {
                    Path extensionPath;
                    if (url.toURI().getScheme().equals("jar")) {
                        FileSystem fileSystem = FileSystems.newFileSystem(url.toURI(), Collections.emptyMap());
                        extensionPath = fileSystem.getPath(ServiceProviderExtensionFinder.getExtensionsResource(), new String[0]);
                    } else {
                        extensionPath = Paths.get(url.toURI());
                    }
                    bucket.addAll(this.readExtensions(extensionPath));
                } else {
                    log.debug("Cannot find '{}'", (Object)ServiceProviderExtensionFinder.getExtensionsResource());
                }
                this.debugExtensions(bucket);
                result.put(pluginId, bucket);
            }
            catch (IOException | URISyntaxException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static String getExtensionsResource() {
        return "META-INF/services";
    }

    private Set<String> readExtensions(Path extensionPath) throws IOException {
        final HashSet<String> result = new HashSet<String>();
        Files.walkFileTree(extensionPath, Collections.emptySet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                log.debug("Read '{}'", (Object)file);
                BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                ServiceProviderExtensionStorage.read(reader, result);
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }
}

