/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppboxing.server.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sportdata.setppboxing.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppboxing.anzeige.beans.ScoringObject;
import org.sportdata.setppboxing.anzeige.properties.helper.AnzeigePropertiesHelper;

public class ScoringServlet
extends HttpServlet {
    public static final String SERVLET_URL = "scoring";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().println("Scoring Request GET 200");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String message = "";
            if (br != null) {
                message = br.readLine();
            }
            if (message != null && !message.trim().equals("") && message.indexOf("ScoreAction") > -1) {
                Gson gson = new Gson();
                JsonParser jsonParser = new JsonParser();
                String json = jsonParser.parse(message).getAsJsonObject().toString();
                ScoringObject obj = (ScoringObject)gson.fromJson(json, ScoringObject.class);
                if (json.indexOf("batterylevel") > -1) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(113, "batterylevel," + obj.getReferee() + "," + obj.getBatterylevel());
                }
                obj.printObject();
                boolean hasvalidscorer = false;
                if (AnzeigePropertiesHelper.getPpboxingenablepointmode().equals("true")) {
                    if (obj.getScoreName().equals("resultinput")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                            if (obj.getReferee() < 6) {
                                AnzeigeMaster.getInstance().getRefereesPoints().put(obj.getReferee(), obj);
                                AnzeigeMaster.getInstance().showRefereePointsWindow();
                            } else {
                                if (obj.getReferee() == 6) {
                                    AnzeigeMaster.getInstance().getAcp().getMatchScoreOverview().addObserverscore(Math.round(obj.getScoreValue()), Math.round(obj.getScoreValue2()));
                                }
                                if (obj.getReferee() == 7) {
                                    AnzeigeMaster.getInstance().getAcp().getMatchScoreOverview().addEvaluatorscore(Math.round(obj.getScoreValue()), Math.round(obj.getScoreValue2()));
                                }
                            }
                            response.setContentType("text/html");
                            response.setStatus(200);
                            response.getWriter().println("Scoring request successfully processed");
                        } else {
                            response.setContentType("text/html");
                            response.setStatus(400);
                            response.getWriter().println("No assignment for imei and referee");
                        }
                    }
                    if (obj.getScoreName().equals("point") || obj.getScoreName().equals("SITCLIENT")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                            if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue()) {
                                if (obj.getScorer().indexOf("RED") > -1) {
                                    obj.setScoreValue(1.0f);
                                    obj.setScoreValue2(0.0f);
                                }
                                if (obj.getScorer().indexOf("BLUE") > -1) {
                                    obj.setScoreValue(0.0f);
                                    obj.setScoreValue2(1.0f);
                                }
                                obj.setScoreName("resultinput_manual");
                                if (AnzeigeMaster.getInstance().getRefereesPoints().containsKey(obj.getReferee())) {
                                    ScoringObject obj2 = AnzeigeMaster.getInstance().getRefereesPoints().get(obj.getReferee());
                                    obj2.setScoreValue(obj2.getScoreValue() + obj.getScoreValue());
                                    obj2.setScoreValue2(obj2.getScoreValue2() + obj.getScoreValue2());
                                } else {
                                    AnzeigeMaster.getInstance().getRefereesPoints().put(obj.getReferee(), obj);
                                }
                                AnzeigeMaster.getInstance().showRefereePointsWindow();
                                response.setContentType("text/html");
                                response.setStatus(200);
                                response.getWriter().println("Scoring request successfully processed");
                            } else {
                                response.setContentType("text/html");
                                response.setStatus(400);
                                response.getWriter().println("Not allowed to score");
                            }
                        } else {
                            response.setContentType("text/html");
                            response.setStatus(400);
                            response.getWriter().println("No assignment for imei and referee");
                        }
                    }
                }
                if (!hasvalidscorer) {
                    response.setContentType("text/html");
                    response.setStatus(400);
                    response.getWriter().println("Request Json not valid");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Request Json not valid");
            }
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Error processing scoring");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

