/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.xml.PersistenceService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import junit.framework.TestCase;

public class LicenseContentTest
extends TestCase
implements Serializable {
    private static final long serialVersionUID = 5692468276257462871L;
    protected LicenseContent content;
    protected Listener listener;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static int staticCount;

    public LicenseContentTest(String testName) {
        super(testName);
    }

    protected void setUp() {
        this.listener = new Listener();
        this.content = new LicenseContent();
        this.content.addPropertyChangeListener(this.listener);
    }

    protected void tearDown() {
        this.content.removePropertyChangeListener(this.listener);
        this.listener = null;
        this.content = null;
    }

    public void testMidnight() {
        long offset = Calendar.getInstance().get(15) + Calendar.getInstance().get(16);
        Date midnight = new Date((System.currentTimeMillis() + offset) / 86400000L * 86400000L - offset);
        LicenseContentTest.assertEquals((long)midnight.getTime(), (long)LicenseManager.midnight().getTime());
    }

    public void testGetHolder() {
        LicenseContentTest.assertNull((Object)this.content.getHolder());
    }

    public void testSetHolder() {
        X500Principal expected = new X500Principal("CN=Test");
        this.content.setHolder(expected);
        LicenseContentTest.assertSame((Object)expected, (Object)this.content.getHolder());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetIssuer() {
        LicenseContentTest.assertNull((Object)this.content.getIssuer());
    }

    public void testSetIssuer() {
        X500Principal expected = new X500Principal("CN=Test");
        this.content.setIssuer(expected);
        LicenseContentTest.assertSame((Object)expected, (Object)this.content.getIssuer());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetSubject() {
        LicenseContentTest.assertNull((Object)this.content.getSubject());
    }

    public void testSetSubject() {
        String expected = "Test";
        this.content.setSubject("Test");
        LicenseContentTest.assertSame((Object)"Test", (Object)this.content.getSubject());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetIssued() {
        LicenseContentTest.assertNull((Object)this.content.getIssued());
    }

    public void testSetIssued() {
        Date expected = LicenseManager.midnight();
        this.content.setIssued(expected);
        LicenseContentTest.assertSame((Object)expected, (Object)this.content.getIssued());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetNotBefore() {
        LicenseContentTest.assertNull((Object)this.content.getNotBefore());
    }

    public void testSetNotBefore() {
        Date expected = new Date();
        this.content.setNotBefore(expected);
        LicenseContentTest.assertSame((Object)expected, (Object)this.content.getNotBefore());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetNotAfter() {
        LicenseContentTest.assertNull((Object)this.content.getNotAfter());
    }

    public void testSetNotAfter() {
        Date expected = new Date();
        this.content.setNotAfter(expected);
        LicenseContentTest.assertSame((Object)expected, (Object)this.content.getNotAfter());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetConsumerType() {
        LicenseContentTest.assertNull((Object)this.content.getConsumerType());
    }

    public void testSetConsumerType() {
        String expected = "Test";
        this.content.setConsumerType("Test");
        LicenseContentTest.assertSame((Object)"Test", (Object)this.content.getConsumerType());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetConsumerAmount() {
        LicenseContentTest.assertEquals((int)1, (int)this.content.getConsumerAmount());
    }

    public void testSetConsumerAmount() {
        int expected = 2;
        this.content.setConsumerAmount(2);
        LicenseContentTest.assertEquals((int)2, (int)this.content.getConsumerAmount());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetInfo() {
        LicenseContentTest.assertNull((Object)this.content.getInfo());
    }

    public void testSetInfo() {
        String expected = "Test";
        this.content.setInfo("Test");
        LicenseContentTest.assertSame((Object)"Test", (Object)this.content.getInfo());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testGetExtra() {
        LicenseContentTest.assertNull((Object)this.content.getExtra());
    }

    public void testSetExtra() {
        String expected = "Test";
        this.content.setExtra("Test");
        LicenseContentTest.assertSame((Object)"Test", (Object)this.content.getExtra());
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getCount());
    }

    public void testEqualsAndHashCode() {
        this.content.setSubject("Test");
        this.content.setHolder(new X500Principal("CN=CaSeIsIgNoReD"));
        LicenseContent other = new LicenseContent();
        other.setSubject("Test");
        other.setHolder(new X500Principal("cn=cAsEiSiGnOrEd"));
        this.content.setIssued(new Date());
        other.setIssued((Date)this.content.getIssued().clone());
        LicenseContentTest.assertEquals((Object)this.content, (Object)this.content);
        LicenseContentTest.assertEquals((Object)other, (Object)other);
        LicenseContentTest.assertEquals((Object)this.content, (Object)other);
        LicenseContentTest.assertEquals((int)this.content.hashCode(), (int)other.hashCode());
    }

    public void testRemovePropertyChangeListener() {
        this.content.removePropertyChangeListener(this.listener);
        this.content.setSubject("Hello world!");
        LicenseContentTest.assertEquals((int)0, (int)this.listener.getCount());
    }

    public synchronized void testObjectStreamPersistence() throws Exception {
        this.content.setNotBefore(new Date(LicenseManager.midnight().getTime() + 86400000L));
        this.content.setSubject("Test Subject");
        this.content.setHolder(new X500Principal("CN=Test"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.content);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        LicenseContent content2 = (LicenseContent)ois.readObject();
        ois.close();
        this.testPersistence(this.content, content2);
    }

    public synchronized void testXMLPersistence() throws Exception {
        this.content.setNotBefore(new Date(LicenseManager.midnight().getTime() + 86400000L));
        this.content.setSubject("Test Subject");
        this.content.setHolder(new X500Principal("CN=Test"));
        byte[] buf = PersistenceService.store2ByteArray((Object)this.content);
        LicenseContent content2 = (LicenseContent)PersistenceService.load((byte[])buf);
        this.testPersistence(this.content, content2);
    }

    protected synchronized void testPersistence(LicenseContent original, LicenseContent clone) {
        LicenseContentTest.assertEqualsButNotSame(original, clone);
        this.listener.resetStaticCount();
        original.setSubject("Test 1");
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getStaticCount());
        clone.setSubject("Test 2");
        LicenseContentTest.assertEquals((int)1, (int)this.listener.getStaticCount());
        clone.addPropertyChangeListener(this.listener);
        clone.setSubject("Test 3");
        LicenseContentTest.assertEquals((int)2, (int)this.listener.getStaticCount());
    }

    private static void assertEqualsButNotSame(LicenseContent expected, LicenseContent actual) {
        LicenseContentTest.assertNotNull((Object)expected);
        LicenseContentTest.assertNotNull((Object)actual);
        LicenseContentTest.assertNotSame((Object)expected, (Object)actual);
        LicenseContentTest.assertEquals((Object)expected, (Object)actual);
        LicenseContentTest.assertEquals((int)expected.getConsumerAmount(), (int)actual.getConsumerAmount());
        LicenseContentTest.assertNullOrNotSame(expected.getConsumerType(), actual.getConsumerType());
        LicenseContentTest.assertNullOrNotSame(expected.getHolder(), actual.getHolder());
        LicenseContentTest.assertNullOrNotSame(expected.getInfo(), actual.getInfo());
        LicenseContentTest.assertNullOrNotSame(expected.getIssued(), actual.getIssued());
        LicenseContentTest.assertNullOrNotSame(expected.getIssuer(), actual.getIssuer());
        LicenseContentTest.assertNullOrNotSame(expected.getNotAfter(), actual.getNotAfter());
        LicenseContentTest.assertNullOrNotSame(expected.getNotBefore(), actual.getNotBefore());
        LicenseContentTest.assertNullOrNotSame(expected.getSubject(), actual.getSubject());
    }

    private static void assertNullOrNotSame(Object expected, Object actual) {
        if (expected != null || actual != null) {
            LicenseContentTest.assertNotSame((Object)expected, (Object)actual);
        }
    }

    protected class Listener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 964284652984278321L;
        private int count;

        protected Listener() {
        }

        public int getCount() {
            return this.count;
        }

        public int getStaticCount() {
            return staticCount;
        }

        public void resetStaticCount() {
            staticCount = 0;
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            LicenseContentTest.assertNotNull((Object)evt);
            LicenseContentTest.assertTrue((boolean)(evt.getSource() instanceof LicenseContent));
            ++this.count;
            staticCount = staticCount + 1;
        }
    }
}

