/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SizeT;
import org.bridj.StructDescription;
import org.bridj.StructFieldDeclaration;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.StructUtils;
import org.bridj.TypedPointer;
import org.bridj.ValuedEnum;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPType;
import org.bridj.util.DefaultParameterizedType;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructFieldDescription {
    public final List<StructFieldDeclaration> aggregatedFields = new ArrayList<StructFieldDeclaration>();
    public long alignment = -1L;
    public long byteOffset = -1L;
    public long byteLength = -1L;
    public long bitOffset;
    public long bitLength = -1L;
    public long arrayLength = 1L;
    public boolean isArray;
    public boolean isNativeObject;
    public Type nativeTypeOrPointerTargetType;
    public Field field;
    Type valueType;
    Method getter;
    String name;
    boolean isCLong;
    boolean isSizeT;

    public void offset(long bytes) {
        this.byteOffset += bytes;
    }

    public String toString() {
        return "Field(byteOffset = " + this.byteOffset + ", byteLength = " + this.byteLength + ", bitOffset = " + this.bitOffset + ", bitLength = " + this.bitLength + (this.nativeTypeOrPointerTargetType == null ? "" : ", ttype = " + this.nativeTypeOrPointerTargetType) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Type resolveType(Type tpe, Type structType) {
        Type ret;
        if (tpe == null || tpe instanceof WildcardType) {
            return null;
        }
        if (tpe instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)tpe;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            Object[] resolvedActualTypeArguments = new Type[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedActualTypeArguments[i] = StructFieldDescription.resolveType(actualTypeArguments[i], structType);
            }
            Type resolvedOwnerType = StructFieldDescription.resolveType(pt.getOwnerType(), structType);
            Type rawType = pt.getRawType();
            ret = tpe instanceof CPPType || CPPObject.class.isAssignableFrom(Utils.getClass(rawType)) ? new CPPType(resolvedOwnerType, rawType, resolvedActualTypeArguments) : new DefaultParameterizedType(resolvedOwnerType, rawType, (Type[])resolvedActualTypeArguments);
        } else if (tpe instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)tpe;
            Class structClass = Utils.getClass(structType);
            TypeVariable<Class<T>>[] typeParameters = structClass.getTypeParameters();
            int i = Arrays.asList(typeParameters).indexOf(tv);
            if (i < 0) throw new RuntimeException("Type param " + tpe + " not found in params of " + structType + " (" + Arrays.asList(typeParameters) + ")");
            if (!(structType instanceof ParameterizedType)) throw new RuntimeException("Type " + structType + " does not have params, cannot resolve " + tpe);
            ParameterizedType pt = (ParameterizedType)structType;
            ret = pt.getActualTypeArguments()[i];
        } else {
            ret = tpe;
        }
        assert (!Utils.containsTypeVariables(ret));
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StructFieldDescription aggregateDeclarations(Type structType, List<StructFieldDeclaration> fieldGroup) {
        StructFieldDescription aggregatedField = new StructFieldDescription();
        boolean isMultiFields = fieldGroup.size() > 1;
        aggregatedField.aggregatedFields.addAll(fieldGroup);
        for (StructFieldDeclaration field : fieldGroup) {
            StructDescription desc;
            if (field.valueClass.isArray()) {
                throw new RuntimeException("Struct fields cannot be array types : please use a combination of Pointer and @Array (for instance, an int[10] is a @Array(10) Pointer<Integer>).");
            }
            if (field.valueClass.isPrimitive()) {
                if (field.desc.isCLong) {
                    field.desc.byteLength = CLong.SIZE;
                } else if (field.desc.isSizeT) {
                    field.desc.byteLength = SizeT.SIZE;
                } else {
                    field.desc.byteLength = StructUtils.primTypeLength(field.valueClass);
                    if (field.desc.alignment < 0L) {
                        field.desc.alignment = StructUtils.primTypeAlignment(field.valueClass, field.desc.byteLength);
                    }
                }
            } else if (field.valueClass == CLong.class) {
                field.desc.byteLength = CLong.SIZE;
            } else if (field.valueClass == SizeT.class) {
                field.desc.byteLength = SizeT.SIZE;
            } else if (StructObject.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field.desc.valueType, structType);
                desc = StructIO.getInstance(field.valueClass, (Type)field.desc.valueType).desc;
                field.desc.byteLength = desc.getStructSize();
                if (field.desc.alignment < 0L) {
                    field.desc.alignment = desc.getStructAlignment();
                }
                field.desc.isNativeObject = true;
            } else if (ValuedEnum.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field.desc.valueType instanceof ParameterizedType ? PointerIO.getClass(((ParameterizedType)field.desc.valueType).getActualTypeArguments()[0]) : null, structType);
                Class<?> c = PointerIO.getClass(field.desc.nativeTypeOrPointerTargetType);
                if (!IntValuedEnum.class.isAssignableFrom(c)) throw new RuntimeException("Enum type unknown : " + c);
                field.desc.byteLength = 4L;
            } else if (TypedPointer.class.isAssignableFrom(field.valueClass)) {
                field.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(field.desc.valueType, structType);
                if (field.desc.isArray) {
                    throw new RuntimeException("Typed pointer field cannot be an array : " + field.desc.name);
                }
                field.desc.byteLength = Pointer.SIZE;
            } else if (Pointer.class.isAssignableFrom(field.valueClass)) {
                Type tpe = field.desc.valueType instanceof ParameterizedType ? ((ParameterizedType)field.desc.valueType).getActualTypeArguments()[0] : null;
                field.desc.nativeTypeOrPointerTargetType = StructFieldDescription.resolveType(tpe, structType);
                if (field.desc.isArray) {
                    field.desc.byteLength = BridJ.sizeOf(field.desc.nativeTypeOrPointerTargetType);
                    if (field.desc.alignment < 0L) {
                        field.desc.alignment = StructUtils.alignmentOf(field.desc.nativeTypeOrPointerTargetType);
                    }
                } else {
                    field.desc.byteLength = Pointer.SIZE;
                }
            } else if (Buffer.class.isAssignableFrom(field.valueClass)) {
                if (field.valueClass == IntBuffer.class) {
                    field.desc.byteLength = 4L;
                } else if (field.valueClass == LongBuffer.class) {
                    field.desc.byteLength = 8L;
                } else if (field.valueClass == ShortBuffer.class) {
                    field.desc.byteLength = 2L;
                } else if (field.valueClass == ByteBuffer.class) {
                    field.desc.byteLength = 1L;
                } else if (field.valueClass == FloatBuffer.class) {
                    field.desc.byteLength = 4L;
                } else {
                    if (field.valueClass != DoubleBuffer.class) throw new UnsupportedOperationException("Field array type " + field.valueClass.getName() + " not supported yet");
                    field.desc.byteLength = 8L;
                }
            } else if (field.valueClass.isArray() && field.valueClass.getComponentType().isPrimitive()) {
                field.desc.byteLength = StructUtils.primTypeLength(field.valueClass.getComponentType());
                if (field.desc.alignment < 0L) {
                    field.desc.alignment = StructUtils.primTypeAlignment(field.valueClass, field.desc.byteLength);
                }
            } else {
                desc = StructIO.getInstance(field.valueClass, (Type)field.desc.valueType).desc;
                long s = desc.getStructSize();
                if (s <= 0L) throw new UnsupportedOperationException("Field type " + field.valueClass.getName() + " not supported yet");
                field.desc.byteLength = s;
            }
            aggregatedField.alignment = Math.max(aggregatedField.alignment, field.desc.alignment >= 0L ? field.desc.alignment : field.desc.byteLength);
            long length = field.desc.arrayLength * field.desc.byteLength;
            if (length >= aggregatedField.byteLength) {
                aggregatedField.byteLength = length;
            }
            if (field.desc.bitLength < 0L) continue;
            if (isMultiFields) {
                throw new RuntimeException("No support for bit fields unions yet !");
            }
            aggregatedField.bitLength = field.desc.bitLength;
            aggregatedField.byteLength = (aggregatedField.bitLength >>> 3) + (long)((aggregatedField.bitLength & 7L) != 0L ? 1 : 0);
        }
        return aggregatedField;
    }
}

