/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import net.sf.sockettest.NetService;
import net.sf.sockettest.SocketServer;
import net.sf.sockettest.Util;
import net.sf.sockettest.swing.PortDialog;

public class SocketTestServer
extends JPanel
implements NetService {
    private final String NEW_LINE = "\r\n";
    private ClassLoader cl = this.getClass().getClassLoader();
    public ImageIcon logo = new ImageIcon(this.cl.getResource("icons/logo.gif"));
    private JPanel topPanel;
    private JPanel toPanel;
    private JPanel centerPanel;
    private JPanel textPanel;
    private JPanel buttonPanel;
    private JPanel sendPanel;
    private JLabel ipLabel = new JLabel("IP Address");
    private JLabel portLabel = new JLabel("Port");
    private JLabel logoLabel = new JLabel("SocketTest v 3.0", this.logo, 0);
    private JTextField ipField = new JTextField("0.0.0.0", 20);
    private JTextField portField = new JTextField("21", 10);
    private JButton portButton = new JButton("Port");
    private JButton connectButton = new JButton("Start Listening");
    private JLabel convLabel = new JLabel("Conversation with Client");
    private Border connectedBorder = BorderFactory.createTitledBorder(new EtchedBorder(), "Connected Client : < NONE >");
    private JTextArea messagesField = new JTextArea();
    private JLabel sendLabel = new JLabel("Message");
    private JTextField sendField = new JTextField();
    private JButton sendButton = new JButton("Send");
    private JButton disconnectButton = new JButton("Disconnect");
    private JButton saveButton = new JButton("Save");
    private JButton clearButton = new JButton("Clear");
    private GridBagConstraints gbc = new GridBagConstraints();
    private Socket socket;
    private ServerSocket server;
    private SocketServer socketServer;
    private PrintWriter out;
    protected final JFrame parent;

    public SocketTestServer(final JFrame jFrame) {
        this.parent = jFrame;
        SocketTestServer socketTestServer = this;
        this.topPanel = new JPanel();
        this.toPanel = new JPanel();
        this.toPanel.setLayout(new GridBagLayout());
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.toPanel.add((Component)this.ipLabel, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 2;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestServer.this.portField.requestFocus();
            }
        };
        this.ipField.addActionListener(actionListener);
        this.toPanel.add((Component)this.ipField, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.toPanel.add((Component)this.portLabel, this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestServer.this.connect();
            }
        };
        this.portField.addActionListener(actionListener2);
        this.toPanel.add((Component)this.portField, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.portButton.setMnemonic('P');
        this.portButton.setToolTipText("View Standard Ports");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PortDialog portDialog = new PortDialog(jFrame, 2);
                portDialog.show();
            }
        };
        this.portButton.addActionListener(actionListener3);
        this.toPanel.add((Component)this.portButton, this.gbc);
        this.gbc.weightx = 0.0;
        this.gbc.gridy = 1;
        this.gbc.gridx = 3;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        this.connectButton.setMnemonic('S');
        this.connectButton.setToolTipText("Start Listening");
        this.connectButton.addActionListener(actionListener2);
        this.toPanel.add((Component)this.connectButton, this.gbc);
        this.toPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Listen On"));
        this.topPanel.setLayout(new BorderLayout(10, 0));
        this.topPanel.add(this.toPanel);
        this.logoLabel.setVerticalTextPosition(3);
        this.logoLabel.setHorizontalTextPosition(0);
        this.topPanel.add((Component)this.logoLabel, "East");
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BorderLayout(0, 5));
        this.textPanel.add((Component)this.convLabel, "North");
        this.messagesField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.messagesField);
        this.textPanel.add(jScrollPane);
        this.textPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        this.sendPanel = new JPanel();
        this.sendPanel.setLayout(new GridBagLayout());
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 0;
        this.sendPanel.add((Component)this.sendLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.sendField.setEditable(false);
        this.sendPanel.add((Component)this.sendField, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.sendButton.setEnabled(false);
        this.sendButton.setToolTipText("Send text to client");
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SocketTestServer.this.sendField.getText();
                if (!string.equals("")) {
                    SocketTestServer.this.sendMessage(string);
                } else {
                    int n = JOptionPane.showConfirmDialog(SocketTestServer.this, "Send Blank Line ?", "Send Data To Client", 0);
                    if (n == 0) {
                        SocketTestServer.this.sendMessage(string);
                    }
                }
            }
        };
        this.sendButton.addActionListener(actionListener4);
        this.sendField.addActionListener(actionListener4);
        this.sendPanel.add((Component)this.sendButton, this.gbc);
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestServer.this.disconnect();
            }
        };
        this.gbc.gridx = 3;
        this.disconnectButton.addActionListener(actionListener5);
        this.disconnectButton.setEnabled(false);
        this.sendPanel.add((Component)this.disconnectButton, this.gbc);
        this.sendPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3), BorderFactory.createTitledBorder("Send")));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 2;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 13;
        this.gbc.fill = 1;
        this.buttonPanel.add((Component)this.sendPanel, this.gbc);
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 0.0;
        this.gbc.gridx = 1;
        this.gbc.gridheight = 1;
        this.gbc.fill = 2;
        this.saveButton.setToolTipText("Save conversation with client to a file");
        this.saveButton.setMnemonic('S');
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = SocketTestServer.this.messagesField.getText();
                if (string.equals("")) {
                    SocketTestServer.this.error("Nothing to save", "Save to file");
                    return;
                }
                String string2 = "";
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("."));
                int n = jFileChooser.showSaveDialog(SocketTestServer.this);
                if (n == 0) {
                    string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    try {
                        Util.writeFile(string2, string);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(SocketTestServer.this, exception.getMessage(), "Error saving to file..", 0);
                    }
                }
            }
        };
        this.saveButton.addActionListener(actionListener6);
        this.buttonPanel.add((Component)this.saveButton, this.gbc);
        this.gbc.gridy = 1;
        this.clearButton.setToolTipText("Clear conversation with client");
        this.clearButton.setMnemonic('C');
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SocketTestServer.this.messagesField.setText("");
            }
        };
        this.clearButton.addActionListener(actionListener7);
        this.buttonPanel.add((Component)this.clearButton, this.gbc);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 3));
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout(0, 10));
        this.centerPanel.add((Component)this.buttonPanel, "South");
        this.centerPanel.add((Component)this.textPanel, "Center");
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10), this.connectedBorder);
        this.centerPanel.setBorder(compoundBorder);
        socketTestServer.setLayout(new BorderLayout(10, 0));
        socketTestServer.add((Component)this.topPanel, "North");
        socketTestServer.add((Component)this.centerPanel, "Center");
    }

    private void connect() {
        if (this.server != null) {
            this.stop();
            return;
        }
        String string = this.ipField.getText();
        String string2 = this.portField.getText();
        if (string == null || string.equals("")) {
            JOptionPane.showMessageDialog(this, "No IP Address. Please enter IP Address", "Error connecting", 0);
            this.ipField.requestFocus();
            this.ipField.selectAll();
            return;
        }
        if (string2 == null || string2.equals("")) {
            JOptionPane.showMessageDialog(this, "No Port number. Please enter Port number", "Error connecting", 0);
            this.portField.requestFocus();
            this.portField.selectAll();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!Util.checkHost(string)) {
            JOptionPane.showMessageDialog(this, "Bad IP Address", "Error connecting", 0);
            this.ipField.requestFocus();
            this.ipField.selectAll();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Bad Port number. Please enter Port number", "Error connecting", 0);
            this.portField.requestFocus();
            this.portField.selectAll();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        try {
            InetAddress inetAddress = null;
            inetAddress = !string.equals("0.0.0.0") ? InetAddress.getByName(string) : null;
            this.server = new ServerSocket(n, 1, inetAddress);
            this.ipField.setEditable(false);
            this.portField.setEditable(false);
            this.connectButton.setText("Stop Listening");
            this.connectButton.setMnemonic('S');
            this.connectButton.setToolTipText("Stop Listening");
        }
        catch (Exception exception) {
            this.error(exception.getMessage(), "Starting Server at " + n);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.messagesField.setText("> Server Started on Port: " + n + "\r\n");
        this.append("> ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        this.socketServer = SocketServer.handle(this, this.server);
    }

    public synchronized void disconnect() {
        try {
            this.socketServer.setDesonnected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        try {
            this.disconnect();
            this.socketServer.setStop(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.ipField.setEditable(true);
        this.portField.setEditable(true);
        this.connectButton.setText("Start Listening");
        this.connectButton.setMnemonic('S');
        this.connectButton.setToolTipText("Start Listening");
        this.append("> Server stopped");
        this.append("> ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public synchronized void setClientSocket(Socket socket) {
        if (socket == null) {
            this.out = null;
            this.socket = null;
            this.changeBorder(null);
            this.sendButton.setEnabled(false);
            this.sendField.setEditable(false);
            this.disconnectButton.setEnabled(false);
        } else {
            this.socket = socket;
            this.changeBorder(" " + this.socket.getInetAddress().getHostName() + " [" + this.socket.getInetAddress().getHostAddress() + "] ");
            this.sendButton.setEnabled(true);
            this.sendField.setEditable(true);
            this.disconnectButton.setEnabled(true);
        }
    }

    public void error(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public void error(String string, String string2) {
        if (string == null || string.equals("")) {
            return;
        }
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    public void append(String string) {
        this.messagesField.append(string + "\r\n");
        this.messagesField.setCaretPosition(this.messagesField.getText().length());
    }

    public void appendnoNewLine(String string) {
        this.messagesField.append(string);
        this.messagesField.setCaretPosition(this.messagesField.getText().length());
    }

    public void sendMessage(String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.out == null) {
                this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
            }
            this.append("S: " + string);
            this.out.print(string + "\r\n");
            this.out.flush();
            this.sendField.setText("");
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error Sending Message", 0);
            this.disconnect();
        }
    }

    private void changeBorder(String string) {
        this.connectedBorder = string == null || string.equals("") ? BorderFactory.createTitledBorder(new EtchedBorder(), "Connected Client : < NONE >") : BorderFactory.createTitledBorder(new EtchedBorder(), "Connected Client : < " + string + " >");
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10), this.connectedBorder);
        this.centerPanel.setBorder(compoundBorder);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setUpConfiguration(String string, String string2) {
        this.ipField.setText(string);
        this.portField.setText(string2);
    }
}

