/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.components.TimePicker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class TimeSpinnerTimer {
    private final TimePicker timePicker;
    private final int changeAmountMinutes;
    private final Timer timer;
    private final int startDelayMillis = 700;
    private final int timerRate = 20;
    private final int[] millisForDivisorList = new int[]{3200, 1800, 800, 800, 800, 800, 800, 0};
    private final int[] divisorList = new int[]{12, 10, 8, 6, 4, 3, 2, 1};
    private long startedIndexTimeStamp = 0L;
    private int currentIndex = 0;
    private int ticksSinceIndexChange;

    public TimeSpinnerTimer(TimePicker timePicker, int changeAmountMinutes) {
        this.timePicker = timePicker;
        this.changeAmountMinutes = changeAmountMinutes;
        this.timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimeSpinnerTimer.this.tick();
            }
        });
        this.timer.setInitialDelay(700);
    }

    private void tick() {
        if (this.startedIndexTimeStamp == 0L) {
            this.startedIndexTimeStamp = System.currentTimeMillis();
        }
        long timeElapsedSinceIndexStartMilliseconds = System.currentTimeMillis() - this.startedIndexTimeStamp;
        int maximumIndex = this.divisorList.length - 1;
        int currentDivisor = this.divisorList[this.currentIndex];
        if (this.ticksSinceIndexChange % currentDivisor == 0) {
            this.timePicker.zInternalTryChangeTimeByIncrement(this.changeAmountMinutes);
            if (this.currentIndex < maximumIndex && timeElapsedSinceIndexStartMilliseconds > (long)this.millisForDivisorList[this.currentIndex]) {
                this.ticksSinceIndexChange = 0;
                ++this.currentIndex;
                this.startedIndexTimeStamp = System.currentTimeMillis();
            }
        }
        ++this.ticksSinceIndexChange;
    }

    public void stop() {
        this.timer.stop();
    }

    public void start() {
        this.startedIndexTimeStamp = 0L;
        this.currentIndex = 0;
        this.ticksSinceIndexChange = 0;
        this.timer.start();
    }
}

