/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectDropDownButton
extends JComponent
implements FocusAwareComponent {
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private Runnable afterFocusRequest;
    private MiniButtonContent content;

    public RoundRectDropDownButton(BasicDropDownButtonHandler handler) {
        this.handler = handler;
        this.model = new BasicDropDownButtonModel(this, handler, handler, true){

            @Override
            protected boolean inDropDownArea(int x, int y) {
                return RoundRectDropDownButton.this.inDropDownArea(x, y);
            }

            @Override
            public void changed() {
                RoundRectDropDownButton.this.revalidate();
                super.changed();
            }
        };
        this.setOpaque(false);
        this.content = this.createButtonContent();
        this.setLayout(null);
        this.add(this.content);
        this.content.setModel(this.model);
        this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        this.dropIcon = handler.getDropDownIcon();
        this.model.addListener(new BasicButtonModelAdapter(){

            @Override
            public void mousePressed(BasicButtonModel model, boolean mousePressed) {
                if (!mousePressed) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RoundRectDropDownButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                RoundRectDropDownButton.this.repaint();
            }
        });
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    @Override
    public void maybeRequestFocus() {
        this.afterFocusRequest = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RoundRectDropDownButton.this.model.isMousePressed()) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
    }

    @Override
    public void invokeOnFocusRequest(Runnable run) {
        this.afterFocusRequest = run;
    }

    private void invokeAfterFocusRequest() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RoundRectDropDownButton.this.afterFocusRequest != null) {
                    RoundRectDropDownButton.this.afterFocusRequest.run();
                    RoundRectDropDownButton.this.afterFocusRequest = null;
                }
            }
        });
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.content.getPreferredSize();
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension(size.width + 6 + this.dropIcon.getIconWidth(), size.height + 2);
        }
        return new Dimension(size.width + 2, size.height + 6 + this.dropIcon.getIconHeight());
    }

    @Override
    public void doLayout() {
        if (this.model.getOrientation().isHorizontal()) {
            this.content.setBounds(1, 1, this.getWidth() - 5 - this.dropIcon.getIconWidth(), this.getHeight() - 2);
        } else {
            this.content.setBounds(1, 1, this.getWidth() - 2, this.getHeight() - 5 - this.dropIcon.getIconHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        BasicDropDownButtonModel model = this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            @Override
            protected void foreground(Graphics g) {
                RoundRectDropDownButton.this.doPaintForeground(g);
            }

            @Override
            protected void background(Graphics g) {
                RoundRectDropDownButton.this.doPaintBackground(g);
            }

            @Override
            protected void border(Graphics g) {
            }

            @Override
            protected void children(Graphics g) {
            }

            @Override
            protected void overlay(Graphics g) {
            }

            @Override
            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        paintable.paint(g);
    }

    private void doPaintBackground(Graphics g) {
        Color background = this.getBackground();
        Color border = null;
        if (this.model.isMousePressed()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.4);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        if (border != null) {
            g.setColor(background);
            g.fillRoundRect(0, 0, w, h, 4, 4);
        }
    }

    private void doPaintForeground(Graphics g) {
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = this.handler.getDisabledDropDownIcon();
            }
            drop = this.disabledDropIcon;
        }
        Color background = this.getBackground();
        Color border = null;
        if (this.model.isMousePressed()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.4);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        if (border != null) {
            g.setColor(border);
            g.drawRoundRect(0, 0, w, h, 4, 4);
            if (this.model.isMouseOverDropDown()) {
                if (this.model.getOrientation().isHorizontal()) {
                    int x = w - drop.getIconWidth() - 5;
                    g.drawLine(x, 0, x, h);
                } else {
                    int y = h - drop.getIconHeight() - 5;
                    g.drawLine(0, y, w, y);
                }
            }
        }
        if (this.model.getOrientation().isHorizontal()) {
            drop.paintIcon(this, g, w - drop.getIconWidth() - 2, (h - drop.getIconHeight()) / 2);
        } else {
            drop.paintIcon(this, g, (w - drop.getIconWidth()) / 2, h - drop.getIconHeight() - 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            g.setColor(Colors.diffMirror(background, 0.4));
            g.drawLine(2, 3, 2, 4);
            g.drawLine(3, 2, 4, 2);
            g.drawLine(w - 2, 3, w - 2, 4);
            g.drawLine(w - 3, 2, w - 4, 2);
            g.drawLine(2, h - 3, 2, h - 4);
            g.drawLine(3, h - 2, 4, h - 2);
            g.drawLine(w - 2, h - 3, w - 2, h - 4);
            g.drawLine(w - 3, h - 2, w - 4, h - 2);
        }
    }

    public boolean inDropDownArea(int x, int y) {
        if (!this.contains(x, y)) {
            return false;
        }
        if (this.model.getOrientation().isHorizontal()) {
            return x >= this.getWidth() - this.dropIcon.getIconWidth() - 5;
        }
        return y >= this.getHeight() - this.dropIcon.getIconHeight() - 5;
    }

    @Override
    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }
}

