/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab4;

import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab4.TabComponentCondition;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class HoverCondition
extends TabComponentCondition {
    private MouseEvent latestEvent;
    private DockController controller;
    private Listener listener = new Listener();

    public HoverCondition(TabComponent component) {
        super(component);
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            GlobalMouseDispatcher dispatcher;
            if (this.controller != null) {
                dispatcher = this.controller.getGlobalMouseDispatcher();
                dispatcher.removeMouseListener(this.listener);
                dispatcher.removeMouseMotionListener(this.listener);
            }
            this.controller = controller;
            if (this.controller != null) {
                dispatcher = this.controller.getGlobalMouseDispatcher();
                dispatcher.addMouseListener(this.listener);
                dispatcher.addMouseMotionListener(this.listener);
            }
            this.invalidate(null);
        }
    }

    @Override
    protected boolean checkCondition() {
        MouseEvent event = this.latestEvent;
        if (event == null) {
            return false;
        }
        Point location = event.getPoint();
        Component component = this.getComponent().getComponent();
        location = SwingUtilities.convertPoint(event.getComponent(), location, component);
        return component.contains(location);
    }

    private void invalidate(MouseEvent event) {
        this.latestEvent = event;
        this.invalidate();
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HoverCondition.this.invalidate(e);
        }
    }
}

