/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.action.dropdown.DefaultDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DropDownActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractSimpleDropDownAction
extends SimpleDockAction
implements DropDownAction {
    private DockAction selection;
    private List<DropDownActionListener> listeners = new ArrayList<DropDownActionListener>();
    private DropDownFilterFactory filter = DefaultDropDownFilter.FACTORY;

    public AbstractSimpleDropDownAction(boolean monitorDisabling) {
        super(monitorDisabling);
    }

    @Override
    public <V> V createView(ViewTarget<V> target, ActionViewConverter converter, Dockable dockable) {
        return converter.createView(ActionType.DROP_DOWN, this, target, dockable);
    }

    @Override
    public DockAction getSelection(Dockable dockable) {
        return this.selection;
    }

    public DockAction getSelection() {
        return this.selection;
    }

    @Override
    public void setSelection(Dockable dockable, DockAction selection) {
        this.setSelection(selection);
    }

    public void setSelection(DockAction selection) {
        if (this.selection != selection) {
            this.selection = selection;
            this.fireSelectionChanged();
        }
    }

    public void setFilter(DropDownFilterFactory filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null");
        }
        this.filter = filter;
    }

    @Override
    public DropDownFilterFactory getFilter(Dockable dockable) {
        return this.filter;
    }

    protected abstract DockActionSource getSubActions();

    @Override
    public DockActionSource getSubActions(Dockable dockable) {
        return this.getSubActions();
    }

    @Override
    public void addDropDownActionListener(DropDownActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDropDownActionListener(DropDownActionListener listener) {
        this.listeners.remove(listener);
    }

    protected DropDownActionListener[] getListeners() {
        return this.listeners.toArray(new DropDownActionListener[this.listeners.size()]);
    }

    protected void fireSelectionChanged() {
        Set<Dockable> dockables = this.getBoundDockables();
        for (DropDownActionListener listener : this.getListeners()) {
            listener.selectionChanged(this, dockables, this.selection);
        }
    }

    @Override
    public boolean trigger(Dockable dockable) {
        if (!this.isEnabled(dockable)) {
            return false;
        }
        if (this.selection != null) {
            return this.selection.trigger(dockable);
        }
        return false;
    }
}

