/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableStateEvent;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public class DockableStateListenerManager {
    private List<DockableStateListener> listeners = new ArrayList<DockableStateListener>();
    private int current = 0;
    private DockStation parent;
    private Dockable dockable;
    private boolean dockableShowing;
    private boolean firing = false;
    private DockableStateListener dockableStateListener = new DockableStateListener(){

        @Override
        public void changed(DockableStateEvent event) {
            int flags = event.getFlags();
            if (event.didLocationChange()) {
                flags &= 0xFFFFFFFE;
                flags |= 2;
            }
            if (event.didParentSelectionChange()) {
                flags &= 0xFFFFFFF7;
                flags |= 0x10;
            }
            if (event.didShowingChange()) {
                boolean newShowing = DockableStateListenerManager.this.dockable.isDockableShowing();
                if (newShowing != DockableStateListenerManager.this.dockableShowing) {
                    DockableStateListenerManager.this.dockableShowing = newShowing;
                    flags |= 4;
                } else {
                    flags &= 0xFFFFFFFB;
                }
            }
            DockableStateListenerManager.this.event(flags);
        }
    };
    private DockHierarchyListener dockHierarchyListener = new DockHierarchyListener(){

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
            if (DockableStateListenerManager.this.parent != null) {
                if (DockableStateListenerManager.this.parent.asDockable() != null) {
                    DockableStateListenerManager.this.parent.asDockable().removeDockableStateListener(DockableStateListenerManager.this.dockableStateListener);
                }
                DockableStateListenerManager.this.parent.removeDockStationListener(DockableStateListenerManager.this.dockStationListener);
                DockableStateListenerManager.this.parent = null;
            }
            DockableStateListenerManager.this.parent = DockableStateListenerManager.this.dockable.getDockParent();
            if (DockableStateListenerManager.this.parent != null) {
                if (DockableStateListenerManager.this.parent.asDockable() != null) {
                    DockableStateListenerManager.this.parent.asDockable().addDockableStateListener(DockableStateListenerManager.this.dockableStateListener);
                }
                DockableStateListenerManager.this.parent.addDockStationListener(DockableStateListenerManager.this.dockStationListener);
            }
            DockableStateListenerManager.this.event(32);
            DockableStateListenerManager.this.checkShowing();
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            DockableStateListenerManager.this.checkShowing();
        }
    };
    private DockStationListener dockStationListener = new DockStationAdapter(){

        @Override
        public void dockableShowingChanged(DockStation station, Dockable changed, boolean visible) {
            if (changed == DockableStateListenerManager.this.dockable) {
                DockableStateListenerManager.this.checkShowing();
            }
        }

        @Override
        public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
            if (oldSelection == DockableStateListenerManager.this.dockable || newSelection == DockableStateListenerManager.this.dockable) {
                DockableStateListenerManager.this.event(8);
            }
        }

        @Override
        public void dockablesRepositioned(DockStation station, Dockable[] dockables) {
            for (Dockable check : dockables) {
                if (check != DockableStateListenerManager.this.dockable) continue;
                DockableStateListenerManager.this.event(1);
                break;
            }
        }
    };

    public DockableStateListenerManager(Dockable dockable) {
        this.dockable = dockable;
    }

    public void checkShowing() {
        boolean newShowing = this.dockable.isDockableShowing();
        if (this.dockableShowing != newShowing) {
            this.dockableShowing = newShowing;
            this.event(4);
        }
    }

    public void addListener(DockableStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        boolean has = this.hasListeners();
        this.listeners.add(listener);
        if (!has && this.hasListeners()) {
            this.install();
        }
    }

    public void removeListener(DockableStateListener listener) {
        boolean has = this.hasListeners();
        this.listeners.remove(listener);
        if (has && !this.hasListeners()) {
            this.uninstall();
        }
    }

    protected boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    public void event(int flags) {
        this.current |= flags;
        if (!this.firing) {
            this.firing = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockableStateListenerManager.this.firing = false;
                    DockableStateListenerManager.this.fireNow();
                }
            });
        }
    }

    private void fireNow() {
        if (this.current != 0) {
            if (this.listeners.size() > 0) {
                DockableStateEvent event = new DockableStateEvent(this.dockable, this.current);
                this.current = 0;
                for (DockableStateListener listener : this.listeners.toArray(new DockableStateListener[this.listeners.size()])) {
                    listener.changed(event);
                }
            }
            this.current = 0;
        }
    }

    protected void install() {
        this.dockable.addDockHierarchyListener(this.dockHierarchyListener);
        this.parent = this.dockable.getDockParent();
        if (this.parent != null) {
            if (this.parent.asDockable() != null) {
                this.parent.asDockable().addDockableStateListener(this.dockableStateListener);
            }
            this.parent.addDockStationListener(this.dockStationListener);
        }
        this.dockableShowing = this.dockable.isDockableShowing();
    }

    protected void uninstall() {
        this.dockable.removeDockHierarchyListener(this.dockHierarchyListener);
        if (this.parent != null) {
            if (this.parent.asDockable() != null) {
                this.parent.asDockable().removeDockableStateListener(this.dockableStateListener);
            }
            this.parent.removeDockStationListener(this.dockStationListener);
            this.parent = null;
        }
    }
}

