/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.window.AbstractScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InternalDockDialog
extends AbstractScreenDockWindow {
    private JDesktopPane desktop;
    private JPanel dialog;

    public InternalDockDialog(ScreenDockStation station, WindowConfiguration configuration, JDesktopPane desktop) {
        this(station, configuration, desktop, JDesktopPane.MODAL_LAYER);
    }

    public InternalDockDialog(ScreenDockStation station, WindowConfiguration configuration, JDesktopPane desktop, int layer) {
        super(station, configuration);
        this.desktop = desktop;
        this.initDialog(configuration, layer);
    }

    private void initDialog(WindowConfiguration configuration, int layer) {
        this.dialog = new JPanel();
        this.dialog.setVisible(false);
        this.desktop.add(this.dialog);
        this.desktop.setLayer(this.dialog, layer);
        if (configuration.isTransparent()) {
            this.dialog.setOpaque(false);
        }
        this.init(this.dialog, this.dialog, configuration, true);
    }

    public int getLayer() {
        return this.desktop.getLayer(this.dialog);
    }

    public void setLayer(int layer) {
        this.desktop.setLayer(this.dialog, layer);
    }

    @Override
    protected void convertPointToScreen(Point point, Component component) {
        Point result = SwingUtilities.convertPoint(component, point, this.desktop);
        point.x = result.x;
        point.y = result.y;
    }

    @Override
    public void destroy() {
        this.dialog.setVisible(false);
        this.desktop.remove(this.dialog);
    }

    @Override
    public void toFront() {
        this.desktop.moveToFront(this.dialog);
    }

    @Override
    public void setPreventFocusStealing(boolean prevent) {
    }
}

