/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutOrder;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutPane;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashSet;

public class MenuLineLayoutPossibility {
    private MenuLineLayoutPane pane;
    private Size menuSize;
    private Size infoSize;
    private Size tabSize;

    public MenuLineLayoutPossibility(MenuLineLayoutPane pane, Size tab, Size menu, Size info) {
        this.pane = pane;
        this.menuSize = menu;
        this.tabSize = tab;
        this.infoSize = info;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@[menu=" + this.menuSize + ", info=" + this.infoSize + ", tabs=" + this.tabSize + "]";
    }

    public double getScore() {
        return this.pane.getLayout().getStrategy().getScore(this, this.menuSize, this.infoSize, this.tabSize);
    }

    public boolean isPreferred() {
        if (this.tabSize == null || !this.tabSize.isPreferred() || !this.getPane().getTabs().isAllTabs(this.tabSize)) {
            return false;
        }
        return this.menuSize == null;
    }

    public MenuLineLayoutPane getPane() {
        return this.pane;
    }

    public Dimension getSize() {
        int width = this.tabSize.getWidth();
        int height = this.tabSize.getHeight();
        if (this.getPane().getPane().getDockTabPlacement().isHorizontal()) {
            if (this.menuSize != null) {
                width += this.menuSize.getWidth();
                height = Math.max(height, this.menuSize.getHeight());
            }
            if (this.infoSize != null) {
                width += this.infoSize.getWidth();
                height = Math.max(height, this.infoSize.getHeight());
            }
        } else {
            if (this.menuSize != null) {
                width = Math.max(width, this.menuSize.getWidth());
                height += this.menuSize.getHeight();
            }
            if (this.infoSize != null) {
                width = Math.max(width, this.infoSize.getWidth());
                height += this.infoSize.getHeight();
            }
        }
        return new Dimension(width, height);
    }

    public void apply() {
        int required;
        MenuLineLayoutPane layout = this.getPane();
        TabPane pane = layout.getPane();
        MenuLineLayoutOrder order = layout.getLayout().getFactory().createOrder(layout.getLayout(), pane);
        AxisConversion conversion = layout.getLayout().getConversion(pane);
        TabPlacement orientation = pane.getDockTabPlacement();
        MenuLayoutBlock menu = layout.getMenu();
        LayoutBlock info = layout.getInfo();
        TabsLayoutBlock tabs = layout.getTabs();
        tabs.setLayout(this.tabSize);
        if (this.infoSize != null && info != null) {
            info.setLayout(this.infoSize);
        }
        if (this.menuSize == null) {
            menu.getMenu().setPaneVisible(false);
        } else {
            menu.getMenu().setPaneVisible(true);
            menu.setLayout(this.menuSize);
        }
        if (this.menuSize != null) {
            HashSet<Dockable> dockables = new HashSet<Dockable>();
            for (Dockable dockable : pane.getDockables()) {
                dockables.add(dockable);
            }
            for (Tab tab : tabs.getTabs(this.tabSize)) {
                dockables.remove(tab.getDockable());
            }
            TabMenu tabMenu = menu.getMenu();
            for (Dockable dockable : dockables) {
                pane.putInMenu(tabMenu, dockable);
            }
        }
        Rectangle available = conversion.viewToModel(pane.getAvailableArea());
        if (orientation.isHorizontal()) {
            required = this.tabSize.getHeight();
            if (this.infoSize != null) {
                required = Math.max(required, this.infoSize.getHeight());
            }
            if (this.menuSize != null) {
                required = Math.max(required, this.menuSize.getHeight());
            }
        } else {
            required = this.tabSize.getWidth();
            if (this.infoSize != null) {
                required = Math.max(required, this.infoSize.getWidth());
            }
            if (this.menuSize != null) {
                required = Math.max(required, this.menuSize.getWidth());
            }
        }
        required = Math.max(0, Math.min(required, available.height / 2));
        pane.setSelectedBounds(conversion.modelToView(new Rectangle(available.x, available.y + required, available.width, available.height - required)));
        int[] widths = this.calculateWidths(orientation, order, available.width, this.tabSize, this.menuSize, this.infoSize);
        int x = available.x;
        for (MenuLineLayoutOrder.Item item : order) {
            int availableWidth = 0;
            Size size = null;
            switch (item) {
                case TABS: {
                    availableWidth = widths[0];
                    size = this.tabSize;
                    break;
                }
                case MENU: {
                    availableWidth = widths[1];
                    size = this.menuSize;
                    break;
                }
                case INFO: {
                    availableWidth = widths[2];
                    if (info == null) break;
                    size = this.infoSize;
                }
            }
            if (size == null) continue;
            int itemWidth = this.calculateWidth(order, item, size, availableWidth, orientation);
            int deltaX = this.calculateDeltaX(order, item, itemWidth, availableWidth);
            switch (item) {
                case INFO: {
                    int reqDelta = orientation.isHorizontal() ? Math.max(0, required - this.infoSize.getHeight()) : Math.max(0, required - this.infoSize.getWidth());
                    Rectangle infoBounds = new Rectangle(x + deltaX, available.y + reqDelta / 2, itemWidth, required - reqDelta);
                    x += availableWidth;
                    infoBounds = conversion.modelToView(infoBounds);
                    info.setBounds(infoBounds.x, infoBounds.y, infoBounds.width, infoBounds.height);
                    break;
                }
                case MENU: {
                    Rectangle menuBounds = new Rectangle(x + deltaX, available.y, itemWidth, required);
                    x += availableWidth;
                    menuBounds = conversion.modelToView(menuBounds);
                    menu.setBounds(menuBounds.x, menuBounds.y, menuBounds.width, menuBounds.height);
                    break;
                }
                case TABS: {
                    Rectangle tabBounds = new Rectangle(x + deltaX, available.y, itemWidth, required);
                    tabBounds = conversion.modelToView(tabBounds);
                    x += availableWidth;
                    tabs.setBounds(tabBounds.x, tabBounds.y, tabBounds.width, tabBounds.height);
                }
            }
        }
    }

    private int calculateWidth(MenuLineLayoutOrder order, MenuLineLayoutOrder.Item item, Size size, int width, TabPlacement orientation) {
        int expected = orientation.isHorizontal() ? size.getWidth() : size.getHeight();
        int overflow = width - expected;
        if (overflow <= 0) {
            return width;
        }
        return expected + (int)(order.getFill(item) * (float)overflow);
    }

    private int calculateDeltaX(MenuLineLayoutOrder order, MenuLineLayoutOrder.Item item, int itemWidth, int availableWidth) {
        int space = availableWidth - itemWidth;
        if (space <= 0) {
            return 0;
        }
        return (int)((float)space * order.getAlignment(item));
    }

    private int[] calculateWidths(TabPlacement orientation, MenuLineLayoutOrder order, int available, Size tabSize, Size menuSize, Size infoSize) {
        int space;
        int tabSpace;
        int[] result = new int[3];
        int menuSpace = 0;
        int infoSpace = 0;
        float weightTabs = order.getWeight(MenuLineLayoutOrder.Item.TABS);
        float weightInfo = 0.0f;
        float weightMenu = 0.0f;
        float totalWeight = weightTabs;
        if (orientation.isHorizontal()) {
            space = tabSpace = tabSize.getWidth();
            if (infoSize != null) {
                infoSpace = infoSize.getWidth();
                weightInfo = order.getWeight(MenuLineLayoutOrder.Item.INFO);
                space += infoSpace;
                totalWeight += weightInfo;
            }
            if (menuSize != null) {
                menuSpace = menuSize.getWidth();
                space += menuSpace;
                weightMenu = order.getWeight(MenuLineLayoutOrder.Item.MENU);
                totalWeight += weightMenu;
            }
        } else {
            space = tabSpace = tabSize.getHeight();
            if (infoSize != null) {
                infoSpace = infoSize.getHeight();
                space += infoSpace;
                weightInfo = order.getWeight(MenuLineLayoutOrder.Item.INFO);
                totalWeight += weightInfo;
            }
            if (menuSize != null) {
                menuSpace = menuSize.getHeight();
                space += menuSpace;
                weightMenu = order.getWeight(MenuLineLayoutOrder.Item.MENU);
                totalWeight += weightMenu;
            }
        }
        int overflowSpace = available - space;
        float tabsWeight = totalWeight == 0.0f ? 0.0f : weightTabs / totalWeight;
        float menuWeight = totalWeight == 0.0f ? 0.0f : weightMenu / totalWeight;
        float infoWeight = totalWeight == 0.0f ? 0.0f : weightInfo / totalWeight;
        int visibleItems = 1;
        if (overflowSpace >= 0) {
            result[0] = (int)((float)tabSpace + tabsWeight * (float)overflowSpace);
            if (menuSize != null) {
                result[1] = (int)((float)menuSpace + menuWeight * (float)overflowSpace);
                ++visibleItems;
            }
            if (infoSize != null) {
                result[2] = (int)((float)infoSpace + infoWeight * (float)overflowSpace);
                ++visibleItems;
            }
        } else {
            float[] maximums = new float[]{tabSpace, menuSpace, infoSpace};
            float[] fArray = new float[]{(float)available * weightTabs, (float)available * weightMenu, (float)available * weightInfo};
            if (menuSize == null) {
                fArray[1] = -1.0f;
            }
            if (infoSize == null) {
                fArray[2] = -1.0f;
            }
            for (int i = 0; i < available; ++i) {
                float maxClaim = -1.0f;
                int maxIndex = -1;
                for (int c = 0; c < 3; ++c) {
                    if (!(fArray[c] > maxClaim)) continue;
                    maxClaim = fArray[c];
                    maxIndex = c;
                }
                if (maxIndex < 0) continue;
                int n = maxIndex;
                fArray[n] = fArray[n] - 1.0f;
                if (fArray[maxIndex] < 0.0f) {
                    fArray[maxIndex] = -0.5f;
                }
                int n2 = maxIndex;
                result[n2] = result[n2] + 1;
                if (!((float)result[maxIndex] >= maximums[maxIndex])) continue;
                fArray[maxIndex] = -1.0f;
            }
            if (menuSize != null) {
                ++visibleItems;
            }
            if (infoSize != null) {
                ++visibleItems;
            }
        }
        int sum = 0;
        for (int r : result) {
            sum += r;
        }
        int n = available - sum;
        if (n != 0) {
            result[0] = result[0] + n / visibleItems;
            if (menuSize != null) {
                result[1] = result[1] + n / visibleItems;
            }
            if (infoSize != null) {
                result[2] = result[2] + n / visibleItems;
            }
            int n3 = n - visibleItems * (n / visibleItems);
            result[0] = result[0] + n3;
        }
        return result;
    }
}

