/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import java.util.HashMap;
import java.util.Map;

public class DockableShowingManager
extends DockStationAdapter {
    private DockStationListenerManager listeners;
    private Map<Dockable, Boolean> visibility = new HashMap<Dockable, Boolean>();

    public DockableShowingManager(DockStationListenerManager listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("Listeners must not be null");
        }
        this.listeners = listeners;
        listeners.addListener(this);
    }

    public void fire() {
        DockStation station = this.listeners.getStation();
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = station.getDockable(i);
            boolean visible = station.isChildShowing(dockable);
            if (this.visibility.containsKey(dockable) && this.visibility.get(dockable) == visible) continue;
            this.listeners.fireDockableVisibilitySet(dockable, visible);
            this.visibility.put(dockable, visible);
        }
    }

    @Override
    public void dockableAdded(DockStation station, Dockable dockable) {
        boolean visible = station.isChildShowing(dockable);
        this.listeners.fireDockableVisibilitySet(dockable, visible);
        this.visibility.put(dockable, visible);
    }

    @Override
    public void dockableRemoved(DockStation station, Dockable dockable) {
        Boolean old = this.visibility.remove(dockable);
        if (old != null && old.booleanValue()) {
            this.listeners.fireDockableVisibilitySet(dockable, false);
        }
    }
}

