/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.List;

public class DockTitleVersion
implements DockTitleFactory {
    public static final Path DOCK_TITLE_VERSION_EXTENSION = new Path("dock.DockTitleVersion");
    public static final String DOCK_TITLE_VERSION_EXTENSION_PARAMETER = "version";
    private DockTitleFactory[] factories = new DockTitleFactory[3];
    private DockTitleFactory[] extensionFactories;
    private String id;
    private DockController controller;
    private List<DockTitleRequest> requests = new ArrayList<DockTitleRequest>();
    private boolean onThemeChange = false;

    public DockTitleVersion(DockController controller, String id) {
        if (controller == null) {
            throw new NullPointerException("Controller must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.controller = controller;
        this.id = id;
        controller.getThemeManager().addUIListener(new UIListener(){

            @Override
            public void updateUI(DockController controller) {
            }

            @Override
            public void themeWillChange(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
                DockTitleVersion.this.onThemeChange = true;
            }

            @Override
            public void themeChanged(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
                DockTitleVersion.this.onThemeChange = false;
            }
        });
        List<DockTitleFactory> list = controller.getExtensions().load(new ExtensionName<DockTitleFactory>(DOCK_TITLE_VERSION_EXTENSION, DockTitleFactory.class, DOCK_TITLE_VERSION_EXTENSION_PARAMETER, this));
        if (!list.isEmpty()) {
            this.extensionFactories = list.toArray(new DockTitleFactory[list.size()]);
        }
    }

    @Override
    public void install(DockTitleRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.requests.add(request);
        DockTitleFactory factory = this.getFactory();
        if (factory != null) {
            factory.install(request);
        }
    }

    @Override
    public void uninstall(DockTitleRequest request) {
        this.requests.remove(request);
        DockTitleFactory factory = this.getFactory();
        if (factory != null) {
            factory.uninstall(request);
        }
    }

    @Override
    public void request(DockTitleRequest request) {
        DockTitleFactory factory;
        DockTitleFactory client = this.getFactory(Priority.CLIENT);
        if (client != null) {
            client.request(request);
            return;
        }
        if (this.extensionFactories != null) {
            for (DockTitleFactory factory2 : this.extensionFactories) {
                factory2.request(request);
                if (!request.isAnswered()) continue;
                return;
            }
        }
        if ((factory = this.getFactory()) != null) {
            factory.request(request);
        }
    }

    public void request() {
        for (DockTitleRequest request : this.requests) {
            request.request();
        }
    }

    private int map(Priority priority) {
        switch (priority) {
            case CLIENT: {
                return 0;
            }
            case THEME: {
                return 1;
            }
        }
        return 2;
    }

    public DockTitleFactory getFactory() {
        for (int i = 0; i < this.factories.length; ++i) {
            if (this.factories[i] == null) continue;
            return this.factories[i];
        }
        return null;
    }

    public void setFactory(DockTitleFactory factory, Priority priority) {
        DockTitleFactory oldFactory = this.getFactory();
        this.factories[this.map((Priority)priority)] = factory;
        DockTitleFactory newFactory = this.getFactory();
        if (oldFactory != newFactory) {
            if (oldFactory != null) {
                for (DockTitleRequest request : this.requests) {
                    oldFactory.uninstall(request);
                }
            }
            if (newFactory != null) {
                for (DockTitleRequest request : this.requests) {
                    newFactory.install(request);
                    if (this.onThemeChange) continue;
                    request.request();
                }
            }
        }
    }

    public DockTitleFactory getFactory(Priority priority) {
        return this.factories[this.map(priority)];
    }

    public boolean isSet(Priority priority) {
        return this.factories[this.map(priority)] != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            return ((DockTitleVersion)obj).id.equals(this.id);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public DockController getController() {
        return this.controller;
    }
}

