/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

public abstract class ResourceRequest<T> {
    private T answer;
    private boolean answered = false;
    private boolean requesting = false;

    protected abstract void answer(T var1, T var2);

    protected void request() {
        this.answered = false;
        T old = this.answer;
        try {
            this.requesting = true;
            this.executeRequestList();
        }
        finally {
            this.requesting = false;
        }
        if (old != this.answer) {
            this.answer(old, this.answer);
        }
    }

    public boolean isAnswered() {
        return this.answered;
    }

    protected abstract void executeRequestList();

    public void requestNull() {
        if (this.answer != null) {
            T old = this.answer;
            this.answer = null;
            this.answer(old, this.answer);
        }
    }

    public void answer(T resource) {
        if (!this.requesting) {
            throw new IllegalStateException("not requesting a title");
        }
        this.validate(resource);
        this.answered = true;
        this.answer = resource;
    }

    protected abstract void validate(T var1);

    public T getAnswer() {
        return this.answer;
    }
}

