/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import atest.jmock.Types;
import junit.framework.AssertionFailedError;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.DynamicMockError;

public class ErrorMessagesAcceptanceTest
extends MockObjectTestCase {
    private static final String MOCK_NAME = "MOCK_NAME";

    public void testUnexpectedCallAlsoShowsExpectedCalls() {
        String arg1 = "arg1";
        String callID = "callID";
        Object arg2 = this.newDummy("arg2");
        Mock mock = this.mock(Types.WithTwoMethods.class, MOCK_NAME);
        this.unregisterToVerify(mock);
        mock.expects(this.once()).method("twoArgsReturnsInt").with(ANYTHING, ANYTHING).will(this.returnValue(1)).id(callID);
        mock.expects(this.once()).method("twoArgsReturnsInt").with(this.eq(arg1), this.same(arg2)).after(callID).will(this.returnValue(1));
        try {
            ((Types.WithTwoMethods)mock.proxy()).noArgsReturnsNothing();
        }
        catch (DynamicMockError error) {
            String errorMessage = error.getMessage();
            String causeOfError = "unexpected invocation";
            String expectedMethod1 = "expected once: twoArgsReturnsInt( ANYTHING, ANYTHING ), returns <1> [" + callID + "]";
            String expectedMethod2 = "expected once: twoArgsReturnsInt( eq(\"" + arg1 + "\"), same(<" + arg2 + ">) ), after " + callID + " (not invoked), returns <1>";
            ErrorMessagesAcceptanceTest.assertStringContains("should contain mock name", errorMessage, MOCK_NAME);
            ErrorMessagesAcceptanceTest.assertStringContains("should report cause of error", errorMessage, causeOfError);
            ErrorMessagesAcceptanceTest.assertSubstringOrder("mock name should appear before cause of error", errorMessage, MOCK_NAME, causeOfError);
            ErrorMessagesAcceptanceTest.assertStringContains("should report invokedMethod that caused error", errorMessage, "noArgsReturnsNothing()");
            ErrorMessagesAcceptanceTest.assertStringContains("should report acceptable methods (#1)", errorMessage, expectedMethod1);
            ErrorMessagesAcceptanceTest.assertStringContains("should report acceptable methods (#2)", errorMessage, expectedMethod2);
            ErrorMessagesAcceptanceTest.assertSubstringOrder("should report acceptable methods in search order", errorMessage, expectedMethod1, expectedMethod2);
            return;
        }
        ErrorMessagesAcceptanceTest.fail((String)"expected DynamicMockError");
    }

    public void testShowsNoExpectationsStringWhenNoExpectationsSet() {
        Mock mock = this.mock(Types.WithTwoMethods.class);
        try {
            ((Types.WithTwoMethods)mock.proxy()).twoArgsReturnsInt("arg1", "arg2");
        }
        catch (DynamicMockError error) {
            String errorMessage = error.getMessage();
            ErrorMessagesAcceptanceTest.assertStringContains("should report no expectations have been set", errorMessage, "No expectations set");
            return;
        }
        ErrorMessagesAcceptanceTest.fail((String)"expected DynamicMockError");
    }

    public void testShowsExpectationThatDoesNotVerify() {
        String arg1 = "arg1";
        Object arg2 = new Object();
        String expectedMethod = "expected once: twoArgsReturnsInt( eq(\"" + arg1 + "\"), same(<" + arg2 + ">) ), returns <1>";
        Mock mock = this.mock(Types.WithTwoMethods.class, MOCK_NAME);
        this.unregisterToVerify(mock);
        mock.expects(this.once()).method("twoArgsReturnsInt").with(this.eq(arg1), this.same(arg2)).will(this.returnValue(1));
        try {
            mock.verify();
        }
        catch (AssertionFailedError ex) {
            String message = ex.getMessage();
            ErrorMessagesAcceptanceTest.assertStringContains("error message should contain expected invokedMethod", message, expectedMethod);
            ErrorMessagesAcceptanceTest.assertStringContains("error message should describe error", message, "was not invoked");
            return;
        }
        ErrorMessagesAcceptanceTest.fail((String)"expected AssertionFailedError");
    }

    public void testReportsFailureWhenStubReturnValueIsNotSet() {
        Mock mock = this.mock(Types.WithTwoMethods.class);
        mock.expects(this.once()).method("twoArgsReturnsInt").with(ANYTHING, ANYTHING);
        try {
            ((Types.WithTwoMethods)mock.proxy()).twoArgsReturnsInt("arg1", "arg2");
        }
        catch (DynamicMockError error) {
            String errorMessage = error.getMessage();
            ErrorMessagesAcceptanceTest.assertStringContains("should report no return value", errorMessage, "tried to return null value");
            return;
        }
        ErrorMessagesAcceptanceTest.fail((String)"expected DynamicMockError");
    }

    public static void assertStringContains(String message, String string, String substring) {
        ErrorMessagesAcceptanceTest.assertTrue((String)(message + ": expected \"" + string + "\" to contain \"" + substring + "\""), (string.indexOf(substring) >= 0 ? 1 : 0) != 0);
    }

    public static void assertSubstringOrder(String message, String string, String earlierSubstring, String laterSubstring) {
        ErrorMessagesAcceptanceTest.assertStringContains(message, string, earlierSubstring);
        ErrorMessagesAcceptanceTest.assertStringContains(message, string, laterSubstring);
        int earlierIndex = string.indexOf(earlierSubstring);
        int laterIndex = string.indexOf(laterSubstring);
        ErrorMessagesAcceptanceTest.assertTrue((String)(message + ": expected \"" + earlierSubstring + "\" " + "to appear before \"" + laterSubstring + "\" in \"" + string + "\""), (earlierIndex < laterIndex ? 1 : 0) != 0);
    }
}

