/*
 * Decompiled with CFR 0.152.
 */
package atest.jmock;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.DynamicMockError;
import org.jmock.expectation.AssertMo;

public class ExpectNeverAcceptanceTest
extends MockObjectTestCase {
    public void testExpectNeverOverridesStubAndFailsIfCalled() {
        Mock mock = this.mock(MockedInterface.class, "mock");
        mock.stubs().method("method").withNoArguments();
        mock.expects(this.never()).method("method").withNoArguments();
        try {
            ((MockedInterface)mock.proxy()).method();
        }
        catch (DynamicMockError error) {
            return;
        }
        ExpectNeverAcceptanceTest.fail((String)"DynamicMockError expected");
    }

    public void testExpectNeverVerifiesIfNotCalled() {
        Mock mock = this.mock(MockedInterface.class, "mock");
        mock.stubs().method("method").withNoArguments().isVoid();
        mock.expects(this.never()).method("method").withNoArguments();
    }

    public void testExpectNeverCanExplicitlyDescribeError() {
        Mock mock = this.mock(MockedInterface.class, "mock");
        String errorMessage = "errorMessage";
        mock.expects(this.never(errorMessage)).method("method").withNoArguments();
        mock.expects(this.never(errorMessage)).method("method").withNoArguments();
        try {
            ((MockedInterface)mock.proxy()).method();
        }
        catch (DynamicMockError error) {
            AssertMo.assertIncludes("should contain explicit error message", errorMessage, error.getMessage());
            return;
        }
        ExpectNeverAcceptanceTest.fail((String)"DynamicMockError expected");
    }

    private static interface MockedInterface {
        public void method();
    }
}

