/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabColumnGroupType;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;

public class CrosstabColumnGroup
extends Group {
    private CrosstabTitleHeader titleHeader;
    private CrosstabHeader header;
    private CrosstabSummaryHeader summaryHeader;

    public CrosstabColumnGroup() {
        this.init();
    }

    public CrosstabColumnGroup(GroupBody body) {
        super(body);
        this.validateBody(body);
        this.init();
    }

    public CrosstabColumnGroup(CrosstabCellBody body) {
        super(body);
        this.init();
    }

    public CrosstabColumnGroup(CrosstabColumnGroupBody body) {
        super(body);
        this.init();
    }

    private void init() {
        this.setElementType(new CrosstabColumnGroupType());
        this.titleHeader = new CrosstabTitleHeader();
        this.summaryHeader = new CrosstabSummaryHeader();
        this.header = new CrosstabHeader();
        this.registerAsChild(this.titleHeader);
        this.registerAsChild(this.summaryHeader);
        this.registerAsChild(this.header);
    }

    public CrosstabTitleHeader getTitleHeader() {
        return this.titleHeader;
    }

    public void setTitleHeader(CrosstabTitleHeader titleHeader) {
        if (titleHeader == null) {
            throw new NullPointerException("titleHeader must not be null");
        }
        this.validateLooping(titleHeader);
        if (this.unregisterParent(titleHeader)) {
            return;
        }
        CrosstabTitleHeader element = this.titleHeader;
        this.titleHeader.setParent(null);
        this.titleHeader = titleHeader;
        this.titleHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleHeader);
    }

    public CrosstabSummaryHeader getSummaryHeader() {
        return this.summaryHeader;
    }

    public void setSummaryHeader(CrosstabSummaryHeader header) {
        if (header == null) {
            throw new NullPointerException("titleFooter must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        CrosstabSummaryHeader element = this.summaryHeader;
        this.summaryHeader.setParent(null);
        this.summaryHeader = header;
        this.summaryHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.summaryHeader);
    }

    public CrosstabHeader getHeader() {
        return this.header;
    }

    public void setHeader(CrosstabHeader header) {
        if (header == null) {
            throw new NullPointerException("titleFooter must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        CrosstabHeader element = this.header;
        this.header.setParent(null);
        this.header = header;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public String getField() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void setField(String field) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", field);
        this.notifyNodePropertiesChanged();
    }

    @Override
    protected GroupBody createDefaultBody() {
        return new CrosstabCellBody();
    }

    @Override
    public void setBody(GroupBody body) {
        this.validateBody(body);
        super.setBody(body);
    }

    private void validateBody(GroupBody body) {
        if (!(body instanceof CrosstabCellBody) && !(body instanceof CrosstabColumnGroupBody)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isGroupChange(DataRow dataRow) {
        String field = this.getField();
        if (field == null) {
            return false;
        }
        return dataRow.isChanged(field);
    }

    @Override
    public CrosstabColumnGroup clone() {
        CrosstabColumnGroup element = (CrosstabColumnGroup)super.clone();
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.clone();
        element.header = (CrosstabHeader)this.header.clone();
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.clone();
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.header);
        element.registerAsChild(element.summaryHeader);
        return element;
    }

    @Override
    public CrosstabColumnGroup derive(boolean preserveElementInstanceIds) {
        CrosstabColumnGroup element = (CrosstabColumnGroup)super.derive(preserveElementInstanceIds);
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.derive(preserveElementInstanceIds);
        element.header = (CrosstabHeader)this.header.derive(preserveElementInstanceIds);
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.derive(preserveElementInstanceIds);
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.header);
        element.registerAsChild(element.summaryHeader);
        return element;
    }

    @Override
    public int getElementCount() {
        return 4;
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.getTitleHeader();
            }
            case 1: {
                return this.getHeader();
            }
            case 2: {
                return this.getSummaryHeader();
            }
            case 3: {
                return this.getBody();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setTitleHeader((CrosstabTitleHeader)element);
                break;
            }
            case 1: {
                this.setHeader((CrosstabHeader)element);
                break;
            }
            case 2: {
                this.setSummaryHeader((CrosstabSummaryHeader)element);
                break;
            }
            case 3: {
                this.setBody((GroupBody)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.titleHeader == element) {
            this.titleHeader.setParent(null);
            this.titleHeader = new CrosstabTitleHeader();
            this.titleHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleHeader);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new CrosstabHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else if (this.summaryHeader == element) {
            this.summaryHeader.setParent(null);
            this.summaryHeader = new CrosstabSummaryHeader();
            this.summaryHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.summaryHeader);
        } else {
            super.removeElement(element);
        }
    }

    public boolean isPrintSummary() {
        Object attribute = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary");
        if (attribute == null) {
            return true;
        }
        return Boolean.TRUE.equals(attribute);
    }

    public void setPrintSummary(boolean printSummary) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary", printSummary);
    }

    @Override
    public List<SortConstraint> getSortingConstraint() {
        return this.mapFields(Collections.singletonList(this.getField()));
    }
}

