/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;

public class IndexedTableModel
implements CloseableTableModel,
MetaTableModel {
    private CloseableTableModel closeableTableModel;
    private TableModel backend;

    public IndexedTableModel(TableModel backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        if (backend instanceof CloseableTableModel) {
            this.closeableTableModel = (CloseableTableModel)backend;
        }
        if (backend instanceof IndexedTableModel) {
            throw new IllegalStateException();
        }
        this.backend = backend;
    }

    @Override
    public void close() {
        if (this.closeableTableModel != null) {
            this.closeableTableModel.close();
        }
    }

    @Override
    public int getRowCount() {
        return this.backend.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return 2 * this.backend.getColumnCount();
    }

    protected int indexToColumn(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = this.backend.getColumnCount();
        if (col >= count * 2) {
            throw new IndexOutOfBoundsException("Requested column '" + col + "' is greater than '" + count * 2 + "'");
        }
        if (col < count) {
            return col;
        }
        return col - count;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (columnIndex < this.backend.getColumnCount()) {
            return this.backend.getColumnName(columnIndex);
        }
        return "::column::" + this.indexToColumn(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.backend.getColumnClass(this.indexToColumn(columnIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.backend.isCellEditable(rowIndex, this.indexToColumn(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.backend.getValueAt(rowIndex, this.indexToColumn(columnIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.backend.setValueAt(aValue, rowIndex, this.indexToColumn(columnIndex));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.backend.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.backend.removeTableModelListener(l);
    }

    @Override
    public DataAttributes getCellDataAttributes(int row, int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    @Override
    public boolean isCellDataAttributesSupported() {
        return false;
    }

    @Override
    public DataAttributes getColumnAttributes(int column) {
        if (column < this.backend.getColumnCount()) {
            return new ColumnIndexDataAttributes(null, Boolean.FALSE, this.getColumnName(column), this.getColumnClass(column), this.getColumnName(column));
        }
        return new ColumnIndexDataAttributes(null, Boolean.TRUE, this.getColumnName(column), this.getColumnClass(column), this.getColumnName(column - this.backend.getColumnCount()));
    }

    @Override
    public DataAttributes getTableAttributes() {
        return EmptyDataAttributes.INSTANCE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("IndexedTableModel");
        sb.append("={backend=").append(this.backend);
        sb.append('}');
        return sb.toString();
    }

    protected static class ColumnIndexDataAttributes
    implements DataAttributes {
        private DataAttributes backend;
        private Boolean indexColumn;
        private String name;
        private Class type;
        private String label;

        public ColumnIndexDataAttributes(DataAttributes backend, Boolean indexColumn, String name, Class type, String label) {
            this.backend = backend;
            this.indexColumn = indexColumn;
            this.name = name;
            this.type = type;
            this.label = label;
            if (backend == null) {
                this.backend = EmptyDataAttributes.INSTANCE;
            }
        }

        @Override
        public String[] getMetaAttributeDomains() {
            LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
            namespaces.addAll(Arrays.asList(this.backend.getMetaAttributeDomains()));
            namespaces.add("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core");
            namespaces.add("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting");
            return namespaces.toArray(new String[namespaces.size()]);
        }

        @Override
        public String[] getMetaAttributeNames(String domainName) {
            if (!"http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName) && !"http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domainName)) {
                return this.backend.getMetaAttributeNames(domainName);
            }
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            names.addAll(Arrays.asList(this.backend.getMetaAttributeNames(domainName)));
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName)) {
                names.add("indexed-column");
                names.add("name");
                names.add("source");
                names.add("value-type");
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domainName)) {
                names.add("label");
            }
            return names.toArray(new String[names.size()]);
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
            return this.getMetaAttribute(domain, name, type, context, null);
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
            Object retval = this.backend.getMetaAttribute(domain, name, type, context, defaultValue);
            if (retval != null) {
                return retval;
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain)) {
                if ("indexed-column".equals(name)) {
                    return this.convert(DefaultConceptQueryMapper.INSTANCE, context, this.indexColumn, type);
                }
                if ("name".equals(name)) {
                    return this.convert(DefaultConceptQueryMapper.INSTANCE, context, this.name, type);
                }
                if ("value-type".equals(name)) {
                    return this.convert(DefaultConceptQueryMapper.INSTANCE, context, this.type, type);
                }
                if ("source".equals(name)) {
                    return this.convert(DefaultConceptQueryMapper.INSTANCE, context, "table", type);
                }
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domain) && "label".equals(name)) {
                return this.convert(DefaultConceptQueryMapper.INSTANCE, context, this.label, type);
            }
            return defaultValue;
        }

        private Object convert(ConceptQueryMapper mapper, DataAttributeContext context, Object value, Class type) {
            return mapper.getValue(value, type, context);
        }

        @Override
        public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain)) {
                if ("indexed-column".equals(name)) {
                    return DefaultConceptQueryMapper.INSTANCE;
                }
                if ("name".equals(name)) {
                    return DefaultConceptQueryMapper.INSTANCE;
                }
                if ("value-type".equals(name)) {
                    return DefaultConceptQueryMapper.INSTANCE;
                }
                if ("source".equals(name)) {
                    return DefaultConceptQueryMapper.INSTANCE;
                }
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domain) && "label".equals(name)) {
                return DefaultConceptQueryMapper.INSTANCE;
            }
            ConceptQueryMapper retval = this.backend.getMetaAttributeMapper(domain, name);
            if (retval != null) {
                return retval;
            }
            return null;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            ColumnIndexDataAttributes dataAttributes = (ColumnIndexDataAttributes)super.clone();
            dataAttributes.backend = (DataAttributes)this.backend.clone();
            return dataAttributes;
        }
    }
}

