/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;

public class OfflineTableModel
implements MetaTableModel {
    private Object[] values;
    private Class[] columnTypes;
    private String[] columnNames;
    private int columnCount;
    private DefaultDataAttributes tableAttributes;
    private DefaultDataAttributes[] columnAttributes;

    public OfflineTableModel(TableModel model, DataAttributeContext dataAttributeContext) {
        int i;
        this.columnCount = model.getColumnCount();
        this.columnTypes = new Class[this.columnCount];
        this.columnNames = new String[this.columnCount];
        this.columnAttributes = new DefaultDataAttributes[this.columnCount];
        this.values = new Object[this.columnCount];
        this.tableAttributes = new DefaultDataAttributes();
        for (i = 0; i < this.columnCount; ++i) {
            this.columnTypes[i] = model.getColumnClass(i);
            this.columnNames[i] = model.getColumnName(i);
            this.columnAttributes[i] = new DefaultDataAttributes();
        }
        if (model instanceof MetaTableModel) {
            MetaTableModel metaTableModel = (MetaTableModel)model;
            this.tableAttributes.merge(metaTableModel.getTableAttributes(), dataAttributeContext);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                this.columnAttributes[i2].merge(metaTableModel.getColumnAttributes(i2), dataAttributeContext);
            }
        }
        if (model.getRowCount() > 0) {
            for (i = 0; i < this.columnCount; ++i) {
                this.values[i] = model.getValueAt(0, i);
            }
        }
    }

    @Override
    public DataAttributes getCellDataAttributes(int row, int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    @Override
    public boolean isCellDataAttributesSupported() {
        return false;
    }

    @Override
    public DataAttributes getColumnAttributes(int column) {
        return this.columnAttributes[column];
    }

    @Override
    public DataAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == 0) {
            return this.values[columnIndex];
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

