/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory;

import java.util.LinkedHashSet;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.util.LibLoaderResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataFactoryEditorSupport {
    public static final String SYNTAX_STYLE_NONE = "text/plain";
    public static final String SYNTAX_STYLE_ASSEMBLER_X86 = "text/asm";
    public static final String SYNTAX_STYLE_C = "text/c";
    public static final String SYNTAX_STYLE_CPLUSPLUS = "text/cpp";
    public static final String SYNTAX_STYLE_CSHARP = "text/cs";
    public static final String SYNTAX_STYLE_CSS = "text/css";
    public static final String SYNTAX_STYLE_FORTRAN = "text/fortran";
    public static final String SYNTAX_STYLE_GROOVY = "text/groovy";
    public static final String SYNTAX_STYLE_HTML = "text/html";
    public static final String SYNTAX_STYLE_JAVA = "text/java";
    public static final String SYNTAX_STYLE_JAVASCRIPT = "text/javascript";
    public static final String SYNTAX_STYLE_JSP = "text/jsp";
    public static final String SYNTAX_STYLE_LUA = "text/lua";
    public static final String SYNTAX_STYLE_MAKEFILE = "text/makefile";
    public static final String SYNTAX_STYLE_PERL = "text/perl";
    public static final String SYNTAX_STYLE_PHP = "text/php";
    public static final String SYNTAX_STYLE_PROPERTIES_FILE = "text/properties";
    public static final String SYNTAX_STYLE_PYTHON = "text/python";
    public static final String SYNTAX_STYLE_RUBY = "text/ruby";
    public static final String SYNTAX_STYLE_SAS = "text/sas";
    public static final String SYNTAX_STYLE_SQL = "text/sql";
    public static final String SYNTAX_STYLE_TCL = "text/tcl";
    public static final String SYNTAX_STYLE_UNIX_SHELL = "text/unix";
    public static final String SYNTAX_STYLE_WINDOWS_BATCH = "text/bat";
    public static final String SYNTAX_STYLE_XML = "text/xml";

    public static ScriptEngineFactory[] getScriptEngineLanguages() {
        LinkedHashSet<ScriptEngineFactory> langSet = new LinkedHashSet<ScriptEngineFactory>();
        langSet.add(null);
        List<ScriptEngineFactory> engineFactories = new ScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory engineFactory : engineFactories) {
            langSet.add(engineFactory);
        }
        return langSet.toArray(new ScriptEngineFactory[langSet.size()]);
    }

    public static String mapLanguageToSyntaxHighlighting(ScriptEngineFactory script) {
        if (script == null) {
            return SYNTAX_STYLE_NONE;
        }
        String language = script.getLanguageName();
        if ("ECMAScript".equalsIgnoreCase(language) || "js".equalsIgnoreCase(language) || "rhino".equalsIgnoreCase(language) || "javascript".equalsIgnoreCase(language)) {
            return SYNTAX_STYLE_JAVASCRIPT;
        }
        if ("groovy".equalsIgnoreCase(language)) {
            return SYNTAX_STYLE_GROOVY;
        }
        return SYNTAX_STYLE_NONE;
    }

    public static void configureDataFactoryForPreview(DataFactory dataFactory, DesignTimeContext context) throws ReportProcessingException {
        DataFactoryEditorSupport.configureDataFactoryForPreview(dataFactory, context, new DataFactory[0]);
    }

    public static void configureDataFactoryForPreview(DataFactory dataFactory, DesignTimeContext context, DataFactory[] additionalDataFactories) throws ReportProcessingException {
        ResourceBundleFactory resourceBundleFactory;
        ResourceManager resourceManager;
        DataFactory reportDataFactory;
        ReportEnvironment reportEnvironment;
        Configuration configuration;
        ResourceKey contentBase;
        AbstractReportDefinition report = context.getReport();
        MasterReport masterReport = DesignTimeUtil.getMasterReport(report);
        if (masterReport == null) {
            contentBase = null;
            configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
            reportEnvironment = new DefaultReportEnvironment(configuration);
            reportDataFactory = null;
            resourceManager = new ResourceManager();
            resourceBundleFactory = new LibLoaderResourceBundleFactory();
        } else {
            contentBase = masterReport.getContentBase();
            configuration = masterReport.getConfiguration();
            reportEnvironment = masterReport.getReportEnvironment();
            reportDataFactory = masterReport.getDataFactory();
            resourceManager = masterReport.getResourceManager();
            resourceBundleFactory = masterReport.getResourceBundleFactory();
        }
        CompoundDataFactory compoundDataFactory = new CompoundDataFactory();
        compoundDataFactory.add(dataFactory);
        for (int i = 0; i < additionalDataFactories.length; ++i) {
            compoundDataFactory.add(additionalDataFactories[i]);
        }
        if (reportDataFactory != null) {
            compoundDataFactory.add(reportDataFactory);
        }
        DesignTimeDataFactoryContext dataFactoryContext = new DesignTimeDataFactoryContext(configuration, resourceManager, contentBase, MasterReport.computeAndInitResourceBundleFactory(resourceBundleFactory, reportEnvironment), compoundDataFactory);
        dataFactory.initialize(dataFactoryContext);
        compoundDataFactory.initialize(dataFactoryContext);
    }
}

