/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.devtools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ElementMetaGenerator {
    private static String readMetadataAttribute(MetaData metaData, String name, String defaultValue) {
        String metaAttribute = metaData.getMetaAttribute(name, Locale.ENGLISH);
        if (metaAttribute == null) {
            return defaultValue;
        }
        return metaAttribute;
    }

    private static void printMetadata(MetaData metaData, String prefix, String name, String defaultValue) {
        System.out.println(prefix + name + "=" + ElementMetaGenerator.readMetadataAttribute(metaData, name, defaultValue));
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        HashMap<String, AttributeCarrier> attributes = new HashMap<String, AttributeCarrier>();
        ElementMetaData[] allTypes = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(allTypes, GroupedMetaDataComparator.ENGLISH);
        System.out.println("# Element definitions");
        for (int i = 0; i < allTypes.length; ++i) {
            AbstractMetaData metaData;
            String prefixMetadata;
            ElementMetaData type = allTypes[i];
            String prefix = type instanceof AbstractMetaData ? (StringUtils.isEmpty((String)(prefixMetadata = (metaData = (AbstractMetaData)((Object)type)).getKeyPrefix())) ? "" : prefixMetadata + type.getName() + ".") : "element." + type.getName() + ".";
            ElementMetaGenerator.printMetadata(type, prefix, "display-name", type.getName());
            ElementMetaGenerator.printMetadata(type, prefix, "grouping", "");
            ElementMetaGenerator.printMetadata(type, prefix, "grouping.ordinal", "0");
            ElementMetaGenerator.printMetadata(type, prefix, "ordinal", "0");
            ElementMetaGenerator.printMetadata(type, prefix, "description", "");
            ElementMetaGenerator.printMetadata(type, prefix, "deprecated", "");
            ElementMetaGenerator.printMetadata(type, prefix, "icon", "");
            System.out.println();
            AttributeMetaData[] attributeDescriptions = type.getAttributeDescriptions();
            for (int j = 0; j < attributeDescriptions.length; ++j) {
                AbstractMetaData metaData2;
                String prefixMetadata2;
                AttributeMetaData attribute = attributeDescriptions[j];
                String attrNs = ElementTypeRegistry.getInstance().getNamespacePrefix(attribute.getNameSpace());
                String attrPrefix = attribute instanceof AbstractMetaData ? (StringUtils.isEmpty((String)(prefixMetadata2 = (metaData2 = (AbstractMetaData)((Object)attribute)).getKeyPrefix())) ? "" : prefixMetadata2 + attribute.getName() + ".") : "element." + type.getName() + ".attribute." + attrNs + "." + attribute.getName();
                attributes.put(attrPrefix, new AttributeCarrier(attrPrefix, attribute));
            }
        }
        System.out.println("# Attribute definitions");
        Object[] attributeMetadata = attributes.values().toArray(new AttributeCarrier[attributes.size()]);
        Arrays.sort(attributeMetadata);
        for (int i = 0; i < attributeMetadata.length; ++i) {
            Object carrier = attributeMetadata[i];
            AttributeMetaData attribute = ((AttributeCarrier)carrier).metaData;
            String attrNs = ElementTypeRegistry.getInstance().getNamespacePrefix(attribute.getNameSpace());
            String attrPrefix = ((AttributeCarrier)carrier).prefix;
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "display-name", attribute.getName());
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "grouping", attrNs);
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "grouping.ordinal", "0");
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "ordinal", "0");
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "description", "");
            ElementMetaGenerator.printMetadata(attribute, attrPrefix, "deprecated", "");
            System.out.println();
        }
    }

    private static class AttributeCarrier
    implements Comparable {
        public AttributeMetaData metaData;
        public String prefix;

        private AttributeCarrier(String prefix, AttributeMetaData metaData) {
            this.prefix = prefix;
            this.metaData = metaData;
        }

        public int compareTo(Object o) {
            AttributeCarrier carrier = (AttributeCarrier)o;
            int compare = GroupedMetaDataComparator.ENGLISH.compare(this.metaData, carrier.metaData);
            if (compare == 0) {
                return this.prefix.compareTo(carrier.prefix);
            }
            return compare;
        }
    }
}

