/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.devtools;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.ClassQueryTool;

public class ExpressionQueryTool
extends ClassQueryTool {
    private ArrayList expressions = new ArrayList();

    protected boolean isValidClass(String className) {
        return !className.startsWith("java.") && !className.startsWith("javax.");
    }

    protected void processClass(ClassLoader classLoader, Class c) {
        if (!Expression.class.isAssignableFrom(c)) {
            return;
        }
        if (c.isInterface()) {
            return;
        }
        int modifiers = c.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return;
        }
        this.expressions.add(c);
    }

    public Class[] getExpressions() {
        return this.expressions.toArray(new Class[this.expressions.size()]);
    }

    public static void main(String[] args) throws IOException {
        ClassicEngineBoot.getInstance().start();
        ExpressionQueryTool eqt = new ExpressionQueryTool();
        eqt.processDirectory(null);
        for (int i = 0; i < eqt.expressions.size(); ++i) {
            System.out.println(eqt.expressions.get(i));
        }
    }
}

