/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class LabelElementFactory
extends TextElementFactory {
    private String text;
    private String excelFormula;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getExcelFormula() {
        return this.excelFormula;
    }

    public void setExcelFormula(String excelFormula) {
        this.excelFormula = excelFormula;
    }

    @Override
    public Element createElement() {
        Element element = new Element();
        element.setElementType(new LabelType());
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.getText());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "formula", this.getExcelFormula());
        return element;
    }

    public static Element createLabelElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String labeltext) {
        return LabelElementFactory.createLabelElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, labeltext);
    }

    public static Element createLabelElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String labeltext) {
        LabelElementFactory factory = new LabelElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setText(labeltext);
        return factory.createElement();
    }
}

