/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.Format;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FormatFilter
implements DataFilter,
RawDataSource {
    private Format format;
    private DataSource datasource;
    private String nullvalue = null;
    private transient String cachedResult;
    private transient Object cachedValue;
    private transient Format cachedFormat;

    protected void invalidateCache() {
        this.cachedFormat = null;
        this.cachedValue = null;
        this.cachedResult = null;
    }

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public Format getFormatter() {
        return this.format;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Format f = this.getFormatter();
        if (f == null) {
            return this.getNullValue();
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return this.getNullValue();
        }
        if (this.cachedResult != null && this.cachedFormat != f && ObjectUtilities.equal((Object)this.cachedValue, (Object)o)) {
            return this.cachedResult;
        }
        try {
            this.cachedResult = f.format(o);
        }
        catch (IllegalArgumentException e) {
            this.cachedResult = this.getNullValue();
        }
        this.cachedFormat = f;
        this.cachedValue = o;
        return this.cachedResult;
    }

    public void setNullValue(String nullvalue) {
        if (nullvalue == null) {
            throw new NullPointerException();
        }
        this.nullvalue = nullvalue;
    }

    public String getNullValue() {
        return this.nullvalue;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.datasource = ds;
    }

    @Override
    public FormatFilter clone() throws CloneNotSupportedException {
        FormatFilter f = (FormatFilter)super.clone();
        if (this.datasource != null) {
            f.datasource = this.datasource.clone();
        }
        if (this.format != null) {
            f.format = (Format)this.format.clone();
            if (this.cachedFormat == this.format) {
                f.cachedFormat = f.format;
            }
        }
        return f;
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        return this.datasource.getValue(runtime, element);
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        if (this.datasource instanceof RawDataSource) {
            RawDataSource rds = (RawDataSource)this.datasource;
            return rds.getFormatString(runtime, element, formatSpecification);
        }
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        formatSpecification.redefine(0, null);
        return formatSpecification;
    }
}

