/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.Format;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.FormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class NumberFormatFilter
extends FormatFilter {
    public NumberFormatFilter() {
        this.setNumberFormat(NumberFormat.getInstance());
    }

    public void setNumberFormat(NumberFormat nf) {
        this.setFormatter(nf);
    }

    public NumberFormat getNumberFormat() {
        return (NumberFormat)this.getFormatter();
    }

    @Override
    public void setFormatter(Format f) {
        NumberFormat fm = (NumberFormat)f;
        super.setFormatter(fm);
    }

    public void setGroupingUsed(boolean newValue) {
        this.getNumberFormat().setGroupingUsed(newValue);
        this.invalidateCache();
    }

    public boolean isGroupingUsed() {
        return this.getNumberFormat().isGroupingUsed();
    }

    public void setMaximumFractionDigits(int newValue) {
        this.getNumberFormat().setMaximumFractionDigits(newValue);
        this.invalidateCache();
    }

    public int getMaximumFractionDigits() {
        return this.getNumberFormat().getMaximumFractionDigits();
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.getNumberFormat().setMaximumFractionDigits(newValue);
        this.invalidateCache();
    }

    public int getMaximumIntegerDigits() {
        return this.getNumberFormat().getMaximumFractionDigits();
    }

    public void setMinimumFractionDigits(int newValue) {
        this.getNumberFormat().setMaximumFractionDigits(newValue);
        this.invalidateCache();
    }

    public int getMinimumFractionDigits() {
        return this.getNumberFormat().getMaximumFractionDigits();
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.getNumberFormat().setMaximumFractionDigits(newValue);
        this.invalidateCache();
    }

    public int getMinimumIntegerDigits() {
        return this.getNumberFormat().getMaximumFractionDigits();
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        DataSource source = this.getDataSource();
        if (source instanceof RawDataSource) {
            RawDataSource rds = (RawDataSource)source;
            return rds.getFormatString(runtime, element, formatSpecification);
        }
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        formatSpecification.redefine(0, null);
        return formatSpecification;
    }
}

