/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public abstract class AbstractElementType
implements ElementType {
    private String id;
    private ElementMetaData metaData;

    protected AbstractElementType(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    @Override
    public ElementMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = ElementTypeRegistry.getInstance().getElementType(this.id);
        }
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractElementType that = (AbstractElementType)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
    }

    @Override
    public ReportElement create() {
        Element element = new Element();
        element.setElementType(this);
        return element;
    }

    @Override
    public ElementType clone() {
        try {
            return (ElementType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    protected String getId() {
        return this.id;
    }
}

