/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ItemBandType;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class ElementVisibilitySwitchFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private transient boolean trigger;
    private transient int count;
    private Boolean newPageState;
    private int numberOfElements = 1;
    private String element;
    private boolean initialState;
    private boolean resetOnGroupStart = true;
    private boolean resetOnPageStart = true;

    @Override
    public void pageStarted(ReportEvent event) {
        if (this.resetOnPageStart) {
            this.trigger = this.newPageState == null ? this.getInitialState() : this.newPageState.booleanValue();
            this.count = 0;
            this.triggerVisibleState(event);
        }
    }

    @Override
    public void pageFinished(ReportEvent event) {
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.trigger = !this.getInitialState();
        this.count = 0;
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        if (this.resetOnGroupStart) {
            this.trigger = !this.getInitialState();
            this.count = 0;
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        this.triggerVisibleState(event);
    }

    private void triggerVisibleState(ReportEvent event) {
        if (this.count % this.numberOfElements == 0) {
            this.trigger = !this.trigger;
        }
        ++this.count;
        if (this.element == null) {
            return;
        }
        ReportElement[] childs = event.getReport().getChildElementsByType(ItemBandType.INSTANCE);
        for (int i = 0; i < childs.length; ++i) {
            ReportElement child = childs[i];
            ReportElement[] elements = child.getChildElementsByName(this.getElement());
            for (int x = 0; x < elements.length; ++x) {
                elements[x].getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, this.trigger);
            }
        }
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public boolean getInitialTriggerValue() {
        return this.initialState;
    }

    public boolean getInitialState() {
        return this.initialState;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    public Boolean getNewPageState() {
        return this.newPageState;
    }

    public void setNewPageState(Boolean newPageState) {
        this.newPageState = newPageState;
    }

    @Override
    public Object getValue() {
        if (this.trigger) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

