/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;

public final class FormulaExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(FormulaExpression.class);
    private transient Formula compiledFormula;
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;
    private Exception formulaError;
    private Boolean failOnError;

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    private FormulaContext getFormulaContext() {
        ProcessingContext globalContext = this.getRuntime().getProcessingContext();
        return globalContext.getFormulaContext();
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String formula) {
        if (ObjectUtilities.equal((Object)this.formula, (Object)formula)) {
            return;
        }
        this.formula = formula;
        if (formula == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            if (formula.endsWith(";")) {
                logger.warn((Object)"A formula with a trailing semicolon is not valid. Auto-correcting the formula.");
                formula = formula.substring(0, formula.length() - 1);
            }
            if (formula.length() > 0 && formula.charAt(0) == '=') {
                this.formulaNamespace = "report";
                this.formulaExpression = formula.substring(1);
            } else {
                int separator = formula.indexOf(58);
                if (separator <= 0 || separator + 1 == formula.length()) {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                } else {
                    this.formulaNamespace = formula.substring(0, separator);
                    this.formulaExpression = formula.substring(separator + 1);
                }
            }
        }
        this.compiledFormula = null;
        this.formulaError = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.formulaError != null) {
            if (Boolean.TRUE.equals(this.failOnError)) {
                throw new InvalidReportStateException(String.format("Previously failed to evaluate formula-expression with error %s", this.formulaError));
            }
            return LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE;
        }
        if (this.formulaExpression == null) {
            return null;
        }
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ExpressionRuntime expressionRuntime = this.getRuntime();
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), expressionRuntime);
        try {
            this.compiledFormula.initialize((FormulaContext)context);
            Object evaluate = this.compiledFormula.evaluate();
            if (Boolean.TRUE.equals(this.failOnError) && evaluate instanceof ErrorValue) {
                throw new InvalidReportStateException(String.format("Failed to evaluate formula-expression with error %s", evaluate));
            }
            Object object = evaluate;
            context.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (Exception e) {
                this.formulaError = e;
                if (logger.isDebugEnabled()) {
                    Configuration config = this.getReportConfiguration();
                    if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.function.LogFormulaFailureCause"))) {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'), (Throwable)e);
                    } else {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'));
                    }
                }
                if (Boolean.TRUE.equals(this.failOnError)) {
                    throw new InvalidReportStateException(String.format("Failed to evaluate formula-expression with error %s", e.getMessage()), e);
                }
                return LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE;
            }
        }
    }

    @Override
    public Object getValue() {
        return this.computeRegularValue();
    }

    public boolean isFormulaError() {
        return this.formulaError != null;
    }

    public Exception getFormulaError() {
        return this.formulaError;
    }

    @Override
    public Expression getInstance() {
        FormulaExpression o = (FormulaExpression)super.getInstance();
        o.compiledFormula = null;
        o.formulaError = null;
        return o;
    }
}

