/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class GenericExpressionRuntime
implements ExpressionRuntime {
    private DataRow dataRow;
    private Configuration configuration;
    private ResourceBundleFactory resourceBundleFactory;
    private TableModel data;
    private int currentRow;
    private ProcessingContext processingContext;
    private DataSchema dataSchema;
    private DataFactory dataFactory;

    public GenericExpressionRuntime() {
        this(new DefaultTableModel(), 0, new DefaultProcessingContext());
    }

    public GenericExpressionRuntime(TableModel data, int currentRow, ProcessingContext processingContext) {
        this(new StaticDataRow(), data, currentRow, processingContext);
    }

    public GenericExpressionRuntime(DataRow dataRow, TableModel data, int currentRow, ProcessingContext processingContext) {
        if (processingContext == null) {
            throw new NullPointerException();
        }
        if (dataRow == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.processingContext = processingContext;
        this.data = data;
        this.currentRow = currentRow;
        this.dataRow = dataRow;
        this.configuration = this.processingContext.getConfiguration();
        this.resourceBundleFactory = processingContext.getResourceBundleFactory();
        this.dataSchema = new DefaultDataSchema();
        this.dataFactory = new CompoundDataFactory();
    }

    public GenericExpressionRuntime(ExpressionRuntime runtime) {
        this(new StaticDataRow(runtime.getDataRow()), runtime.getData(), runtime.getCurrentRow(), runtime.getProcessingContext());
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @Override
    public DataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public TableModel getData() {
        return this.data;
    }

    @Override
    public int getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public int getCurrentDataItem() {
        return this.currentRow;
    }

    @Override
    public String getExportDescriptor() {
        return this.processingContext.getExportDescriptor();
    }

    @Override
    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    @Override
    public int getCurrentGroup() {
        return 0;
    }

    @Override
    public int getGroupStartRow(String groupName) {
        return 0;
    }

    @Override
    public int getGroupStartRow(int groupIndex) {
        return 0;
    }

    @Override
    public boolean isStructuralComplexReport() {
        return false;
    }

    @Override
    public boolean isCrosstabActive() {
        return false;
    }
}

