/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.GroupCountFunction;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class TotalGroupCountFunction
extends GroupCountFunction {
    private transient HashMap<ReportStateKey, Integer> results = new HashMap();
    private transient Integer result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;

    @Override
    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.result = IntegerCache.getInteger(this.getCount());
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = this.results.get(this.globalStateKey);
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        String definedGroupName;
        super.groupStarted(event);
        if (FunctionUtilities.isDefinedGroup(this.getParentGroup(), event)) {
            this.groupStateKey = event.getState().getProcessKey();
            if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                this.result = IntegerCache.getInteger(this.getCount());
                this.results.put(this.globalStateKey, this.result);
                this.results.put(this.groupStateKey, this.result);
                return;
            }
            this.result = this.results.get(this.groupStateKey);
        }
        if (((definedGroupName = this.getGroup()) == null || FunctionUtilities.isDefinedGroup(definedGroupName, event)) && FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.result = IntegerCache.getInteger(this.getCount());
            this.results.put(this.globalStateKey, this.result);
            this.results.put(this.groupStateKey, this.result);
        }
    }

    @Override
    public Object getValue() {
        return this.result;
    }

    @Override
    public Expression getInstance() {
        TotalGroupCountFunction fn = (TotalGroupCountFunction)super.getInstance();
        fn.results = new HashMap();
        return fn;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
    }
}

