/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionUtilities;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StateSequence;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TotalGroupSumFunction
extends AbstractFunction
implements FieldAggregationFunction {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final int ZERO_I = 0;
    private StateSequence<BigDecimal> stateSequence = new StateSequence();
    private transient int lastGroupSequenceNumber;
    private String field;
    private String group;
    private transient Sequence<BigDecimal> result;
    private transient ReportStateKey globalStateKey;
    protected transient ReportStateKey currentGroupKey;
    private String crosstabFilterGroup;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (this.isPrepareRunLevel(event)) {
            this.result = new Sequence();
            this.stateSequence.clear();
            this.stateSequence.add(this.globalStateKey, this.result);
            this.lastGroupSequenceNumber = 0;
        } else {
            this.result = this.stateSequence.resultExists() ? this.stateSequence.getResult(0) : null;
            this.lastGroupSequenceNumber = 0;
        }
    }

    protected boolean isPrepareRunLevel(ReportEvent event) {
        return FunctionUtilities.isDefinedPrepareRunLevel(this, event);
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.currentGroupKey = event.getState().getProcessKey();
            if (this.isPrepareRunLevel(event)) {
                this.clear();
                int pos = this.stateSequence.getKeyIndex(this.currentGroupKey);
                if (pos == -1) {
                    this.stateSequence.add(this.currentGroupKey, this.result);
                } else {
                    this.stateSequence.updateResult(pos, this.result);
                }
            } else {
                int found = this.stateSequence.getKeyIndex(this.currentGroupKey);
                this.result = found < 0 ? null : this.stateSequence.getResult(found);
            }
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    protected void clear() {
        this.result = new Sequence();
        this.lastGroupSequenceNumber = 0;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        if (!this.isPrepareRunLevel(event)) {
            return;
        }
        BigDecimal value = ExpressionUtilities.convertToBigDecimal(event.getDataRow().get(this.getField()));
        if (value == null) {
            return;
        }
        BigDecimal oldValue = this.result.get(this.lastGroupSequenceNumber);
        if (oldValue == null) {
            this.result.set(this.lastGroupSequenceNumber, value);
        } else {
            this.result.set(this.lastGroupSequenceNumber, oldValue.add(value));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TotalGroupSumFunction o = (TotalGroupSumFunction)super.clone();
        o.stateSequence = new StateSequence(this.stateSequence.getKeys().size());
        if (this.result != null) {
            o.result = this.result.clone();
        }
        for (int i = 0; i < this.stateSequence.getKeys().size(); ++i) {
            ReportStateKey reportStateKey = this.stateSequence.getKeys().get(i);
            if (reportStateKey.equals(this.globalStateKey) || reportStateKey.equals(this.currentGroupKey)) {
                o.stateSequence.add(reportStateKey, o.result);
                continue;
            }
            o.stateSequence.add(reportStateKey, this.stateSequence.getResult(i));
        }
        return o;
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public Object getValue() {
        if (this.result == null) {
            return ZERO;
        }
        BigDecimal value = this.result.get(this.lastGroupSequenceNumber);
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public Expression getInstance() {
        TotalGroupSumFunction function = (TotalGroupSumFunction)super.getInstance();
        function.result = null;
        function.stateSequence = new StateSequence();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.result = null;
        this.stateSequence = new StateSequence();
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

