/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class MetaDataFunction
implements Function {
    public String getCanonicalName() {
        return "METADATA";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        ReportFormulaContext rfc;
        DataAttributes data;
        Class type;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 3 && parameterCount != 4) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        String fieldName = context.getTypeRegistry().convertToText(parameters.getType(0), parameters.getValue(0));
        String metaNamespace = context.getTypeRegistry().convertToText(parameters.getType(1), parameters.getValue(1));
        String metaName = context.getTypeRegistry().convertToText(parameters.getType(2), parameters.getValue(2));
        if (parameterCount == 4) {
            String typeStr = context.getTypeRegistry().convertToText(parameters.getType(3), parameters.getValue(3));
            ClassLoader loader = ObjectUtilities.getClassLoader(MetaDataFunction.class);
            try {
                type = Class.forName(typeStr, false, loader);
            }
            catch (ClassNotFoundException e) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
            }
        } else {
            type = String.class;
        }
        if ((data = (rfc = (ReportFormulaContext)context).getDataSchema().getAttributes(fieldName)) == null) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext(rfc.getProcessingContext().getOutputProcessorMetaData(), rfc.getLocalizationContext().getLocale());
        Object o = data.getMetaAttribute(metaNamespace, metaName, type, attributeContext);
        return new TypeValuePair((Type)AnyType.TYPE, o);
    }
}

