/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.awt.Color;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.filter.types.ResourceLabelType;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;

public class MetaDataStyleEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private transient VolatileDataAttributeContext attributeContext;
    private Boolean legacyMode;

    private boolean isLegacyMode() {
        if (this.legacyMode != null) {
            return this.legacyMode;
        }
        if (this.getRuntime() == null) {
            return false;
        }
        this.legacyMode = "false".equals(this.getRuntime().getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.WizardAllowAttributeChangeWithoutStyleChange"));
        return this.legacyMode;
    }

    @Override
    public int getProcessingPriority() {
        return 4000;
    }

    public VolatileDataAttributeContext getAttributeContext() {
        if (this.attributeContext == null) {
            this.attributeContext = new VolatileDataAttributeContext();
        }
        return this.attributeContext;
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        DataSchema dataSchema = this.getRuntime().getDataSchema();
        Object allowStylingFlag = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling");
        Object allowAttributesFlag = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes");
        if (!Boolean.TRUE.equals(allowStylingFlag) && !Boolean.TRUE.equals(allowAttributesFlag)) {
            return false;
        }
        String fieldName = (String)e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for");
        if (fieldName == null && (fieldName = (String)e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field")) == null) {
            return false;
        }
        DataAttributes attributes = dataSchema.getAttributes(fieldName);
        if (attributes == null) {
            return false;
        }
        VolatileDataAttributeContext context = this.getAttributeContext();
        String typeName = e.getElementType().getMetaData().getName();
        if (Boolean.TRUE.equals(allowStylingFlag)) {
            Boolean bold = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "bold", Boolean.class, context);
            Boolean italic = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "italic", Boolean.class, context);
            Boolean strikethrough = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "strikethrough", Boolean.class, context);
            Boolean underline = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "underline", Boolean.class, context);
            Integer fontSize = (Integer)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "font-size", Integer.class, context);
            String font = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "font-family", String.class, context);
            Color textColor = (Color)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "color", Color.class, context);
            Color bgColor = (Color)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "background-color", Color.class, context);
            ElementAlignment hAlign = (ElementAlignment)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "horizontal-alignment", ElementAlignment.class, context);
            ElementAlignment vAlign = (ElementAlignment)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/style", "vertical-alignment", ElementAlignment.class, context);
            ElementStyleSheet styleSheet = e.getStyle();
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-valignment"))) {
                styleSheet.setStyleProperty(ElementStyleKeys.VALIGNMENT, vAlign);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-alignment"))) {
                if (hAlign != null) {
                    styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, hAlign);
                } else if (!LabelType.INSTANCE.getMetaData().getName().equals(typeName) && !ResourceLabelType.INSTANCE.getMetaData().getName().equals(typeName)) {
                    styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, MetaDataStyleEvaluator.computeAlignment(attributes, context));
                }
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-background-color"))) {
                styleSheet.setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, bgColor);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-color"))) {
                styleSheet.setStyleProperty(ElementStyleKeys.PAINT, textColor);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontfamily"))) {
                styleSheet.setStyleProperty(TextStyleKeys.FONT, font);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontsize"))) {
                styleSheet.setStyleProperty(TextStyleKeys.FONTSIZE, fontSize);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-underline"))) {
                styleSheet.setStyleProperty(TextStyleKeys.UNDERLINED, underline);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-bold"))) {
                styleSheet.setStyleProperty(TextStyleKeys.BOLD, bold);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-strikethrough"))) {
                styleSheet.setStyleProperty(TextStyleKeys.STRIKETHROUGH, strikethrough);
            }
            if (this.isMetaStylingEnabled(e.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-italics"))) {
                styleSheet.setStyleProperty(TextStyleKeys.ITALIC, italic);
            }
        }
        boolean legacyMode = this.isLegacyMode();
        if (Boolean.TRUE.equals(allowAttributesFlag) && (!legacyMode || Boolean.TRUE.equals(allowStylingFlag))) {
            String format;
            if (!LabelType.INSTANCE.getMetaData().getName().equals(typeName) && !ResourceLabelType.INSTANCE.getMetaData().getName().equals(typeName)) {
                format = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "format", String.class, context);
                if (format != null) {
                    e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", format);
                } else {
                    String autoFormat = AutoGeneratorUtility.computeFormatString(attributes, context);
                    e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", autoFormat);
                }
            } else if ("label".equals(typeName)) {
                format = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", String.class, context);
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", format);
            }
        }
        return true;
    }

    private boolean isMetaStylingEnabled(Object b) {
        if (b == null) {
            return true;
        }
        return Boolean.TRUE.equals(b);
    }

    private static ElementAlignment computeAlignment(DataAttributes attributes, DataAttributeContext context) {
        Class type = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, context);
        if (Number.class.isAssignableFrom(type)) {
            return ElementAlignment.RIGHT;
        }
        return ElementAlignment.LEFT;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MetaDataStyleEvaluator o = (MetaDataStyleEvaluator)super.clone();
        o.attributeContext = null;
        return o;
    }

    @Override
    public MetaDataStyleEvaluator getInstance() {
        MetaDataStyleEvaluator eval = (MetaDataStyleEvaluator)super.getInstance();
        eval.attributeContext = null;
        return eval;
    }

    private class VolatileDataAttributeContext
    implements DataAttributeContext {
        private VolatileDataAttributeContext() {
        }

        @Override
        public Locale getLocale() {
            ExpressionRuntime expressionRuntime = MetaDataStyleEvaluator.this.getRuntime();
            if (expressionRuntime == null) {
                throw new IllegalStateException();
            }
            return expressionRuntime.getResourceBundleFactory().getLocale();
        }

        @Override
        public OutputProcessorMetaData getOutputProcessorMetaData() {
            ExpressionRuntime expressionRuntime = MetaDataStyleEvaluator.this.getRuntime();
            if (expressionRuntime == null) {
                throw new IllegalStateException();
            }
            return expressionRuntime.getProcessingContext().getOutputProcessorMetaData();
        }
    }
}

