/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.pentaho.reporting.engine.classic.core.layout.model.InlineProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ProgressMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class GroupSection
implements Cloneable {
    private StyleSheet styleSheet;
    private FlatGroupSectionStrategy strategy;

    public GroupSection(RenderBox groupBox, StyleSheet styleSheet, int predictedSize, boolean legacyMode) {
        if (groupBox == null) {
            throw new NullPointerException();
        }
        this.styleSheet = styleSheet;
        this.strategy = predictedSize <= 15 ? new FlatGroupSectionStrategy(groupBox, styleSheet) : (legacyMode ? new LegacyGroupSectionStrategy(groupBox, styleSheet, 0) : new QuadraticGroupSection(groupBox, styleSheet, predictedSize));
    }

    public boolean mergeSection(ReportStateKey stateKey) {
        return this.strategy.mergeSection(stateKey);
    }

    public void addedSection(RenderNode node) {
        this.strategy.addedSection(node);
    }

    public void removedLastSection(RenderNode child) {
        this.strategy.removedLastSection(child);
    }

    public void close() {
        this.strategy.close();
    }

    public RenderBox getGroupBox() {
        return this.strategy.getGroupBox();
    }

    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    public int getChildCount() {
        return this.strategy.getChildCount();
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public GroupSection deriveForPagebreak() {
        GroupSection clone = (GroupSection)this.clone();
        clone.strategy = (FlatGroupSectionStrategy)this.strategy.clone();
        return clone;
    }

    public GroupSection deriveForStorage(RenderBox clonedParent) {
        GroupSection clone = (GroupSection)this.clone();
        clone.strategy = this.strategy.deriveForStorage(clonedParent);
        return clone;
    }

    public void performParanoidModelCheck() {
        RenderBox c = this.strategy.getAddBox();
        if (this.strategy.getChildCount() > 0) {
            while (c != this.strategy.getGroupBox()) {
                if ((c = c.getParent()) != null) continue;
                throw new IllegalStateException("Failed to locate parent");
            }
        }
        for (c = this.strategy.getAddBox(); c != null; c = c.getParent()) {
            if (c.isOpen()) continue;
            throw new IllegalStateException("Add-Box is not open: " + c.isMarkedOpen() + ' ' + c.isMarkedSeen() + ' ' + c);
        }
    }

    public void performPostCommitModelCheck() {
        RenderBox groupBox = this.strategy.getGroupBox();
        if (!groupBox.isMarkedSeen()) {
            throw new IllegalStateException("No seen-marker at " + groupBox);
        }
        if (this.strategy.getChildCount() > 0) {
            RenderBox addBox = this.strategy.getAddBox();
            if (addBox.getParent() == null) {
                throw new IllegalStateException("No longer there");
            }
            if (!addBox.isMarkedSeen()) {
                throw new IllegalStateException("No seen-marker at add-box " + addBox);
            }
            if (!addBox.isMarkedOpen()) {
                throw new IllegalStateException("No open-marker at " + addBox);
            }
        }
    }

    public void restoreStateAfterRollback() {
        this.strategy.restoreStateAfterRollback();
    }

    public RenderBox getAddBox() {
        return this.strategy.getAddBox();
    }

    private static class LegacyGroupSectionStrategy
    extends FlatGroupSectionStrategy {
        private static final int INITIAL_COMMON_SIZE = 50;
        private int predictedGrowth;
        private int predictedSize;

        protected LegacyGroupSectionStrategy(RenderBox groupBox, StyleSheet styleSheet, int predictedSize) {
            super(groupBox, styleSheet);
            this.predictedSize = predictedSize;
            if (predictedSize == 0) {
                this.initGrowth(50);
            } else {
                this.predictedGrowth = (int)Math.max(5.0, Math.sqrt(predictedSize));
                this.initGrowth(this.predictedGrowth);
            }
        }

        @Override
        protected int computeGrowth() {
            if (this.predictedSize == 0 || this.getChildCount() > this.predictedSize) {
                return (int)Math.min(5000.0, (double)this.getChildCount() * 0.5);
            }
            return this.predictedGrowth;
        }
    }

    private static class QuadraticGroupSection
    extends FlatGroupSectionStrategy {
        private int predictedGrowth;
        private int predictedSize;

        public QuadraticGroupSection(RenderBox groupBox, StyleSheet styleSheet, int predictedSize) {
            super(groupBox, styleSheet);
            this.predictedSize = predictedSize;
            this.predictedGrowth = (int)Math.ceil(Math.pow(predictedSize, 0.4));
            RenderBox commonBox = groupBox.create(styleSheet);
            commonBox.setName("Common-Section");
            this.setAddBox(commonBox);
            this.getGroupBox().addChild(this.getAddBox());
            this.initGrowth(Math.max(5, this.predictedGrowth));
        }

        @Override
        public void addedSection(RenderNode node) {
            super.addedSection(node);
        }

        @Override
        protected int computeGrowth() {
            return this.predictedGrowth;
        }
    }

    private static class FlatGroupSectionStrategy
    implements Cloneable {
        protected static final double COMMON_GROWTH = 0.5;
        protected static final int INITIAL_COMMON_SIZE = 50;
        protected static final int MAXIMUM_COMMON_SIZE = 5000;
        private int childCount;
        private int nextBoxStart;
        private StyleSheet styleSheet;
        private RenderBox addBox;
        private RenderBox groupBox;

        private FlatGroupSectionStrategy(RenderBox addBox, StyleSheet styleSheet) {
            this.groupBox = addBox;
            this.addBox = addBox;
            this.styleSheet = styleSheet;
            this.childCount = 0;
            this.nextBoxStart = 50;
        }

        protected void initGrowth(int growth) {
            this.nextBoxStart = growth;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cse) {
                throw new IllegalStateException(cse);
            }
        }

        public boolean mergeSection(ReportStateKey stateKey) {
            RenderNode lastSection = this.getAddBox().getLastChild();
            if (lastSection == null) {
                return false;
            }
            if ((lastSection.getLayoutNodeType() & 2) != 2) {
                return false;
            }
            RenderBox lastSectionBox = (RenderBox)lastSection;
            RenderNode maybeMarker = lastSectionBox.getLastChild();
            if (maybeMarker == null) {
                return false;
            }
            int nodeType = maybeMarker.getNodeType();
            if (nodeType == 16777282) {
                InlineProgressMarkerRenderBox markerRenderBox = (InlineProgressMarkerRenderBox)maybeMarker;
                markerRenderBox.setStateKey(stateKey);
                return true;
            }
            if (nodeType == 0x1000012) {
                ProgressMarkerRenderBox markerRenderBox = (ProgressMarkerRenderBox)maybeMarker;
                markerRenderBox.setStateKey(stateKey);
                return true;
            }
            return false;
        }

        public RenderBox getGroupBox() {
            return this.groupBox;
        }

        public void setAddBox(RenderBox addBox) {
            this.addBox = addBox;
        }

        public RenderBox getAddBox() {
            return this.addBox;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public void addedSection(RenderNode node) {
            ++this.childCount;
            if (this.childCount == this.nextBoxStart) {
                if (this.addBox != this.groupBox) {
                    this.addBox.close();
                }
                RenderBox commonBox = this.addBox.create(this.styleSheet);
                commonBox.setName("Common-Section");
                this.groupBox.addChild(commonBox);
                this.addBox = commonBox;
                this.nextBoxStart += this.computeGrowth();
            }
            this.addBox.addChild(node);
        }

        public void removedLastSection(RenderNode child) {
            --this.childCount;
            this.addBox.remove(child);
        }

        protected int computeGrowth() {
            if (this.nextBoxStart == 0) {
                return 50;
            }
            return (int)Math.min(5000.0, (double)this.nextBoxStart * 0.5);
        }

        public void close() {
            if (this.addBox != this.groupBox) {
                this.addBox.close();
            }
            this.groupBox.close();
        }

        public FlatGroupSectionStrategy deriveForStorage(RenderBox clonedParent) {
            RenderBox addBoxClone;
            RenderBox groupBoxClone;
            FlatGroupSectionStrategy clone = (FlatGroupSectionStrategy)this.clone();
            InstanceID groupBoxInstanceId = this.groupBox.getInstanceId();
            if (clonedParent == null) {
                groupBoxClone = (RenderBox)clone.groupBox.derive(true);
            } else {
                groupBoxClone = (RenderBox)clonedParent.findNodeById(groupBoxInstanceId);
                if (groupBoxClone == null) {
                    throw new IllegalStateException("The pagebox did no longer contain the stored node.");
                }
                if (groupBoxClone == this.groupBox) {
                    throw new IllegalStateException("Thought you wanted a groupBoxClone");
                }
            }
            RenderBox addBox = this.getAddBox();
            if (addBox == this.groupBox) {
                addBoxClone = groupBoxClone;
            } else {
                InstanceID addBoxInstanceId = addBox.getInstanceId();
                addBoxClone = (RenderBox)groupBoxClone.findNodeById(addBoxInstanceId);
                if (addBoxClone == null) {
                    throw new IllegalStateException("The pagebox did no longer contain the stored node.");
                }
                if (addBoxClone == addBox) {
                    throw new IllegalStateException("Thought you wanted a groupBoxClone");
                }
            }
            clone.addBox = addBoxClone;
            clone.groupBox = groupBoxClone;
            return clone;
        }

        public void restoreStateAfterRollback() {
            if (!this.addBox.isOpen() && this.addBox.getParent() == null) {
                this.addBox = this.groupBox.create(this.styleSheet);
            }
        }
    }
}

