/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ElementChangeChecker {
    private final Log performanceLogger = LogFactory.getLog(this.getClass());
    private PerformanceCollector performanceCollector = new PerformanceCollector();
    private String attrName = "ElementChangeTracker-NeedResult@" + System.identityHashCode(this);
    private String elementAttribute = "ElementChangeTracker-DetailResult@" + System.identityHashCode(this);
    private DataRow currentDataRow;
    private HashMap<String, Object> currentFieldsAndValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBandChanged(Section b, DataRow dataRow) {
        this.currentFieldsAndValues.clear();
        this.currentDataRow = dataRow;
        try {
            boolean bl = this.processRootBand(b);
            return bl;
        }
        finally {
            this.currentFieldsAndValues.clear();
            this.currentDataRow = null;
        }
    }

    protected final boolean processRootBand(Section b) {
        if (b == null) {
            return false;
        }
        NeedEvalResult needToRun = (NeedEvalResult)b.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.attrName);
        if (needToRun != null && !needToRun.isNeedToRun() && needToRun.isValid(b, this.currentDataRow)) {
            this.recordCacheHit(b);
            return false;
        }
        this.recordCacheMiss(b);
        boolean needToRunVal = this.processBand(b);
        b.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.attrName, new NeedEvalResult(needToRunVal, b, (HashMap)this.currentFieldsAndValues.clone()), false);
        return true;
    }

    protected boolean evaluateElement(ReportElement e) {
        ElementMetaDataEvaluationResult evalResult = (ElementMetaDataEvaluationResult)e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.elementAttribute);
        if (evalResult != null && evalResult.isValid(e, this.currentDataRow)) {
            this.currentFieldsAndValues.putAll(evalResult.seenFields);
            return false;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        ElementMetaData metaData = e.getElementType().getMetaData();
        AttributeMetaData[] attributeDescriptions = metaData.getAttributeDescriptions();
        for (int i = 0; i < attributeDescriptions.length; ++i) {
            AttributeMetaData attributeDescription = attributeDescriptions[i];
            Object attribute = e.getAttribute(attributeDescription.getNameSpace(), attributeDescription.getName());
            if (attribute == null) continue;
            String[] referencedFields = attributeDescription.getReferencedFields(e, attribute);
            for (int j = 0; j < referencedFields.length; ++j) {
                String field = referencedFields[j];
                Object value = this.currentDataRow.get(field);
                values.put(field, value);
                this.currentFieldsAndValues.put(field, value);
            }
        }
        ElementMetaDataEvaluationResult current = new ElementMetaDataEvaluationResult(e, values);
        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.elementAttribute, current, false);
        return true;
    }

    protected final boolean processBand(Section b) {
        boolean hasAttrExpressions = this.evaluateElement(b);
        int length = b.getElementCount();
        for (int i = 0; i < length; ++i) {
            Element element = b.getElement(i);
            ElementMetaData.TypeClassification reportElementType = element.getMetaData().getReportElementType();
            if (reportElementType == ElementMetaData.TypeClassification.DATA || reportElementType == ElementMetaData.TypeClassification.CONTROL || reportElementType == ElementMetaData.TypeClassification.SUBREPORT || !(element instanceof Section)) {
                if (!this.evaluateElement(element)) continue;
                hasAttrExpressions = true;
                continue;
            }
            Section section = (Section)element;
            if (!this.processBand(section)) continue;
            hasAttrExpressions = true;
        }
        return hasAttrExpressions;
    }

    protected void recordCacheHit(ReportElement e) {
        ++this.performanceCollector.totalEvaluations;
        ++this.performanceCollector.skippedEvaluations;
    }

    protected void recordCacheMiss(ReportElement e) {
        ++this.performanceCollector.totalEvaluations;
        ++this.performanceCollector.evaluations;
    }

    protected void reportCachePerformance() {
        if (this.performanceLogger.isInfoEnabled()) {
            this.performanceLogger.info((Object)String.format("Performance: %s => total=%d, evaluated=%d (%f%%), avoided=%d (%f%%)", this.getClass(), this.performanceCollector.totalEvaluations, this.performanceCollector.evaluations, Float.valueOf(100.0f * (float)this.performanceCollector.evaluations / Math.max(1.0f, (float)this.performanceCollector.totalEvaluations)), this.performanceCollector.skippedEvaluations, Float.valueOf(100.0f * (float)this.performanceCollector.skippedEvaluations / Math.max(1.0f, (float)this.performanceCollector.totalEvaluations))));
        }
    }

    private static class PerformanceCollector {
        public int totalEvaluations;
        public int evaluations;
        public int skippedEvaluations;

        private PerformanceCollector() {
        }
    }

    private static class ElementMetaDataEvaluationResult
    implements Serializable {
        private long changeTracker;
        private long styleChangeTracker;
        private long styleModificationCounter;
        private HashMap<String, Object> seenFields;

        private ElementMetaDataEvaluationResult(ReportElement e, HashMap<String, Object> seenFields) {
            this.seenFields = seenFields;
            this.changeTracker = e.getChangeTracker();
            this.styleChangeTracker = e.getStyle().getChangeTracker();
            this.styleModificationCounter = e.getStyle().getModificationCount();
        }

        public boolean isValid(ReportElement e, DataRow dataRow) {
            if (this.changeTracker != e.getChangeTracker() || this.styleChangeTracker != e.getStyle().getChangeTracker() || this.styleModificationCounter != e.getStyle().getModificationCount()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : this.seenFields.entrySet()) {
                Object currentValue;
                String field = entry.getKey();
                Object oldValue = entry.getValue();
                if (ObjectUtilities.equal((Object)oldValue, (Object)(currentValue = dataRow.get(field)))) continue;
                return false;
            }
            return true;
        }
    }

    private static class NeedEvalResult
    implements Serializable {
        private boolean needToRun;
        private long changeTracker;
        private long styleChangeTracker;
        private long styleModificationCounter;
        private HashMap<String, Object> fieldsAndValues;

        private NeedEvalResult(boolean needToRun, ReportElement e, HashMap<String, Object> fieldsAndValues) {
            this.needToRun = needToRun;
            this.changeTracker = e.getChangeTracker();
            this.fieldsAndValues = fieldsAndValues;
            this.styleChangeTracker = e.getStyle().getChangeTracker();
            this.styleModificationCounter = e.getStyle().getModificationCount();
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public boolean isValid(ReportElement e, DataRow dataRow) {
            if (this.changeTracker != e.getChangeTracker() || this.styleChangeTracker != e.getStyle().getChangeTracker() || this.styleModificationCounter != e.getStyle().getModificationCount()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : this.fieldsAndValues.entrySet()) {
                Object currentValue;
                String field = entry.getKey();
                Object oldValue = entry.getValue();
                if (ObjectUtilities.equal((Object)oldValue, (Object)(currentValue = dataRow.get(field)))) continue;
                return false;
            }
            return true;
        }
    }
}

