/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.process.TableRowHeightApplyStep;

public class TableRowHeightCalculation {
    private TableInfoStructure currentTable;
    private boolean secondPass;
    private TableRowHeightApplyStep applyStep = new TableRowHeightApplyStep();

    public TableRowHeightCalculation(boolean secondPass) {
        this.secondPass = secondPass;
    }

    public void reset() {
        this.currentTable = null;
    }

    public void startTableBox(TableRenderBox box) {
        this.currentTable = new TableInfoStructure(box, this.currentTable);
    }

    public void finishTable(TableRenderBox box) {
        long newHeight = this.currentTable.getFilledHeight();
        box.setCachedHeight(newHeight);
        this.currentTable = this.currentTable.pop();
    }

    public void startTableSection(TableSectionRenderBox sectionBox) {
        this.currentTable.setRowModel(sectionBox.getRowModel());
    }

    public void startTableCell(TableCellRenderBox box) {
        if (!this.secondPass) {
            long size = 0L;
            for (int i = 0; i < box.getRowSpan(); ++i) {
                size += this.currentTable.getPreferredRowSize(i);
            }
            box.setCachedHeight(size);
        } else {
            long size = 0L;
            for (int i = 0; i < box.getRowSpan(); ++i) {
                size += this.currentTable.getValidatedRowSize(i);
            }
            box.setCachedHeight(size);
        }
    }

    public void finishTableCell(TableCellRenderBox cellBox, long cachedHeight) {
        if (!this.secondPass) {
            int rowSpan = cellBox.getRowSpan();
            this.currentTable.updateValidatedSize(rowSpan, 0, cachedHeight);
        } else {
            long size = 0L;
            for (int i = 0; i < cellBox.getRowSpan(); ++i) {
                size += this.currentTable.getValidatedRowSize(i);
            }
            cellBox.setCachedHeight(size);
        }
    }

    public void startTableRow(TableRowRenderBox box) {
        this.currentTable.setRowNumber(box.getRowIndex());
    }

    public void finishTableSection(TableSectionRenderBox section) {
        TableRowModel rowModel = section.getRowModel();
        if (section.getRowModelAge() != section.getChangeTracker()) {
            rowModel.validateActualSizes();
            section.setRowModelAge(section.getChangeTracker());
        }
        long usedTableBodyHeight = this.applyStep.start(section);
        this.currentTable.setFilledHeight(usedTableBodyHeight + this.currentTable.getFilledHeight());
        this.currentTable.setRowModel(null);
    }

    private static class TableInfoStructure {
        private TableRenderBox table;
        private TableInfoStructure parent;
        private TableColumnModel columnModel;
        private TableRowModel rowModel;
        private int rowNumber;
        private long filledHeight;

        public TableInfoStructure(TableRenderBox table, TableInfoStructure parent) {
            this.table = table;
            this.parent = parent;
            this.columnModel = table.getColumnModel();
        }

        public TableInfoStructure pop() {
            return this.parent;
        }

        public long getFilledHeight() {
            return this.filledHeight;
        }

        public void setFilledHeight(long filledHeight) {
            if (filledHeight < 0L) {
                throw new IllegalStateException("Filled height is negative: " + filledHeight);
            }
            this.filledHeight = filledHeight;
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public void setRowModel(TableRowModel rowModel) {
            this.rowModel = rowModel;
        }

        public void setRowNumber(int rowNumber) {
            this.rowNumber = rowNumber;
        }

        public long getPreferredRowSize(int offset) {
            return this.rowModel.getPreferredRowSize(this.rowNumber + offset);
        }

        public long getValidatedRowSize(int offset) {
            return this.rowModel.getValidatedRowSize(this.rowNumber + offset);
        }

        public void updateValidatedSize(int rowSpan, int leading, long cachedHeight) {
            this.rowModel.updateValidatedSize(this.rowNumber, rowSpan, leading, cachedHeight);
        }
    }
}

