/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.layoutrules;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;

public class DefaultSequenceList
implements SequenceList {
    private ArrayList<RenderNode> nodeList;
    private ArrayList<InlineSequenceElement> sequenceElementList;

    public DefaultSequenceList() {
        this(50);
    }

    public DefaultSequenceList(int initialSize) {
        this.nodeList = new ArrayList(initialSize);
        this.sequenceElementList = new ArrayList(initialSize);
    }

    @Override
    public RenderNode getNode(int index) {
        return this.nodeList.get(index);
    }

    @Override
    public InlineSequenceElement getSequenceElement(int index) {
        return this.sequenceElementList.get(index);
    }

    @Override
    public long getMinimumLength(int index) {
        return this.getSequenceElement(index).getMaximumWidth(this.nodeList.get(index));
    }

    @Override
    public void clear() {
        this.nodeList.clear();
        this.sequenceElementList.clear();
    }

    @Override
    public void add(InlineSequenceElement element, RenderNode node) {
        if (element == null || node == null) {
            throw new NullPointerException();
        }
        this.sequenceElementList.add(element);
        this.nodeList.add(node);
    }

    @Override
    public int size() {
        return this.nodeList.size();
    }

    @Override
    public InlineSequenceElement[] getSequenceElements(InlineSequenceElement[] target) {
        return this.sequenceElementList.toArray(target);
    }

    @Override
    public RenderNode[] getNodes(RenderNode[] target) {
        return this.nodeList.toArray(target);
    }
}

