/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.MinorAxisLayoutStepUtil;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StaticChunkWidthUpdate;

public class StaticVerticalChunkWidthUpdate
extends StaticChunkWidthUpdate {
    private RenderBox box;
    private long chunkWidth;
    private long minimumBorderBoxWidth;
    private StackedObjectPool<StaticVerticalChunkWidthUpdate> pool;

    StaticVerticalChunkWidthUpdate(StackedObjectPool<StaticVerticalChunkWidthUpdate> pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    void reuse(StaticChunkWidthUpdate parent, RenderBox box) {
        this.reuse(parent);
        this.box = box;
        this.chunkWidth = 0L;
        this.minimumBorderBoxWidth = MinorAxisLayoutStepUtil.resolveNodeWidthForMinChunkCalculation(box);
    }

    @Override
    public void update(long minChunkWidth) {
        if (this.chunkWidth < minChunkWidth) {
            this.chunkWidth = minChunkWidth;
        }
    }

    @Override
    public void finish() {
        long chunkWidthAndInsets = Math.max(this.minimumBorderBoxWidth, this.chunkWidth + this.box.getInsets());
        if (this.box.getMinimumChunkWidth() < chunkWidthAndInsets) {
            this.box.setMinimumChunkWidth(chunkWidthAndInsets);
        }
    }

    @Override
    public StaticChunkWidthUpdate pop() {
        this.box = null;
        this.chunkWidth = 0L;
        this.minimumBorderBoxWidth = 0L;
        this.pool.free(this);
        return super.pop();
    }
}

