/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.reporting.engine.classic.core.ReportProcessTask;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ReportProcessTaskMetaDataCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ReportProcessTaskRegistry {
    private ConcurrentHashMap<String, ReportProcessTaskMetaData> exportTypes;
    private static ReportProcessTaskRegistry processTaskRegistry;
    private ResourceManager resourceManager = new ResourceManager();

    public static synchronized ReportProcessTaskRegistry getInstance() {
        if (processTaskRegistry == null) {
            processTaskRegistry = new ReportProcessTaskRegistry();
        }
        return processTaskRegistry;
    }

    private ReportProcessTaskRegistry() {
        this.exportTypes = new ConcurrentHashMap();
    }

    public void registerFromXml(URL expressionMetaSource) throws IOException {
        if (expressionMetaSource == null) {
            throw new NullPointerException("Error: Could not find the report-preprocessor meta-data description file");
        }
        try {
            Resource resource = this.resourceManager.createDirectly((Object)expressionMetaSource, ReportProcessTaskMetaDataCollection.class);
            ReportProcessTaskMetaDataCollection typeCollection = (ReportProcessTaskMetaDataCollection)resource.getResource();
            ReportProcessTaskMetaData[] types = typeCollection.getMetaData();
            for (int i = 0; i < types.length; ++i) {
                ReportProcessTaskMetaData metaData = types[i];
                if (metaData == null) continue;
                this.registerExportType(metaData);
            }
        }
        catch (Exception e) {
            throw new IOException("Error: Could not parse the element meta-data description file", e);
        }
    }

    public void registerExportType(ReportProcessTaskMetaData exportTask) {
        if (exportTask == null) {
            throw new NullPointerException();
        }
        this.exportTypes.put(exportTask.getName(), exportTask);
    }

    public ReportProcessTaskMetaData[] getAll() {
        return this.exportTypes.values().toArray(new ReportProcessTaskMetaData[this.exportTypes.size()]);
    }

    public String[] getExportTypes() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.exportTypes.keySet())).toArray(new String[this.exportTypes.size()]);
    }

    public boolean isExportTypeRegistered(String exportType) {
        return this.exportTypes.containsKey(exportType);
    }

    public ReportProcessTask createProcessTask(String exportType) {
        ReportProcessTaskMetaData c = this.exportTypes.get(exportType);
        if (c == null) {
            throw new IllegalArgumentException();
        }
        return c.create();
    }

    public ReportProcessTask createProcessTaskByAlias(String exportType) {
        for (ReportProcessTaskMetaData c : this.exportTypes.values()) {
            String[] alias = c.getAlias();
            if (!Arrays.asList(alias).contains(exportType)) continue;
            return c.create();
        }
        throw new IllegalArgumentException();
    }
}

