/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.builder.MetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractMetaDataReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(AbstractMetaDataReadHandler.class);
    private String bundle;
    private MetaDataBuilder<?> builder;

    protected AbstractMetaDataReadHandler() {
    }

    protected AbstractMetaDataReadHandler(String bundle) {
        this.bundle = bundle;
    }

    protected MetaDataBuilder<?> getBuilder() {
        if (this.builder == null) {
            this.builder = new DataHolderMetaDataBuilder();
        }
        return this.builder;
    }

    protected String parseName(Attributes attrs) throws ParseException {
        String name = attrs.getValue(this.getUri(), "name");
        if (name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        return name;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String bundleFromAttributes;
        if (!this.isDerivedName()) {
            this.getBuilder().name(this.parseName(attrs));
        }
        if ((bundleFromAttributes = attrs.getValue(this.getUri(), "bundle-name")) != null) {
            this.bundle = bundleFromAttributes;
        }
        boolean experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.getBuilder().maturity(this.parseMaturityLevel(attrs.getValue(this.getUri(), "maturity-level"), experimental));
        this.getBuilder().expert("true".equals(attrs.getValue(this.getUri(), "expert")));
        this.getBuilder().hidden("true".equals(attrs.getValue(this.getUri(), "hidden")));
        this.getBuilder().preferred("true".equals(attrs.getValue(this.getUri(), "preferred")));
        this.getBuilder().deprecated("true".equals(attrs.getValue(this.getUri(), "deprecated")));
        this.getBuilder().since(ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level")));
    }

    private MaturityLevel parseMaturityLevel(String level, boolean experimentalAsDefault) {
        try {
            if (level != null) {
                return MaturityLevel.valueOf(level);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.getLocator() != null) {
                logger.debug((Object)String.format("Invalid attribute-value for maturity-level in metadata declaration [Line {0}, Column {1}]", this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()));
            }
            logger.debug((Object)"Invalid attribute-value for maturity-level in metadata declaration");
        }
        if (experimentalAsDefault) {
            return MaturityLevel.Development;
        }
        return MaturityLevel.Production;
    }

    protected boolean isDerivedName() {
        return false;
    }

    public int getCompatibilityLevel() {
        return this.getBuilder().getCompatibilityLevel();
    }

    public String getName() {
        return this.getBuilder().getName();
    }

    public boolean isPreferred() {
        return this.getBuilder().isPreferred();
    }

    public boolean isExpert() {
        return this.getBuilder().isExpert();
    }

    public boolean isHidden() {
        return this.getBuilder().isHidden();
    }

    public boolean isDeprecated() {
        return this.getBuilder().isDeprecated();
    }

    public String getBundle() {
        return this.bundle;
    }

    @Deprecated
    public boolean isExperimental() {
        return this.getMaturityLevel().isExperimental();
    }

    public MaturityLevel getMaturityLevel() {
        return this.getBuilder().getMaturityLevel();
    }

    private static class DataHolderMetaDataBuilder
    extends MetaDataBuilder<DataHolderMetaDataBuilder> {
        private DataHolderMetaDataBuilder() {
        }

        @Override
        protected DataHolderMetaDataBuilder self() {
            return this;
        }
    }
}

