/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class AbsoluteLengthPropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Float value;

    @Override
    public void setValue(Object value) {
        Float oldValue = this.value;
        if (!(value instanceof Float)) {
            this.value = null;
        } else {
            this.value = (Float)value;
            if (this.value.floatValue() < 0.0f) {
                this.value = null;
            }
        }
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.value.longValue() == Long.MAX_VALUE || this.value.longValue() == Long.MIN_VALUE) {
            return "auto";
        }
        if (this.value.floatValue() < 0.0f) {
            return "0";
        }
        return this.value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(AbsoluteLengthPropertyEditor.parseRelativeFloat(text));
    }

    public static Float parseRelativeFloat(String value) {
        if (value == null) {
            return null;
        }
        if ("auto".equalsIgnoreCase(value)) {
            return new Float(-9.223372E18f);
        }
        try {
            String tvalue = value.trim();
            float f = Float.parseFloat(tvalue);
            if (f < 0.0f) {
                return new Float(-f);
            }
            return new Float(f);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

