/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.PaginatedUpdateListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.NumericInputDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class GoToActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private static final Log logger = LogFactory.getLog(GoToActionPlugin.class);
    private ResourceBundleSupport resources;
    private PaginatedUpdateListener updateListener = new PaginatedUpdateListener(this);

    @Override
    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        swingGuiContext.getEventSource().removePropertyChangeListener(this.updateListener);
    }

    @Override
    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        context.getEventSource().addPropertyChangeListener(this.updateListener);
        this.setEnabled(context.getEventSource().isPaginated());
        return true;
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.base.go-to.";
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.gotopage.name");
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.gotopage.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.gotopage.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.gotopage.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.gotopage.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.gotopage.mnemonic");
    }

    @Override
    public boolean configure(PreviewPane reportPane) {
        Integer result = NumericInputDialog.showInputDialog(this.getContext().getWindow(), 3, this.resources.getString("dialog.gotopage.title"), this.resources.getString("dialog.gotopage.message"), 1, reportPane.getNumberOfPages(), reportPane.getPageNumber(), true);
        if (result == null) {
            return false;
        }
        try {
            int page = result;
            if (page > 0 && page <= reportPane.getNumberOfPages()) {
                reportPane.setPageNumber(page);
            }
        }
        catch (Exception ex) {
            logger.info((Object)this.resources.getString("GoToActionPlugin.INFO_EXCEPTION_SWALLOWED"));
        }
        return false;
    }
}

