/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.internal;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ExportAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ZoomAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ZoomListActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.ActionCategory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.CategoryTreeItem;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.DefaultIconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionPluginMenuComparator;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.DefaultActionFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PreviewPaneUtilities {
    private static final String ICON_THEME_CONFIG_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme";
    private static final String ACTION_FACTORY_CONFIG_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.ActionFactory";
    private static final String CATEGORY_PREFIX = "org.pentaho.reporting.engine.classic.core.modules.gui.swing.category.";
    private static final ZoomAction[] EMPTY_ZOOM_ACTION = new ZoomAction[0];

    private PreviewPaneUtilities() {
    }

    public static JMenu createMenu(ActionCategory cat) {
        String toolTip;
        JMenu menu = new JMenu();
        menu.setText(cat.getDisplayName());
        Integer mnemonicKey = cat.getMnemonicKey();
        if (mnemonicKey != null) {
            menu.setMnemonic(mnemonicKey);
        }
        if ((toolTip = cat.getShortDescription()) != null && toolTip.length() > 0) {
            menu.setToolTipText(toolTip);
        }
        return menu;
    }

    public static ZoomAction[] buildMenu(JMenu menu, ActionPlugin[] actions, PreviewPane pane) {
        if (actions.length == 0) {
            return EMPTY_ZOOM_ACTION;
        }
        ZoomAction[] retval = EMPTY_ZOOM_ACTION;
        Arrays.sort(actions, new ActionPluginMenuComparator());
        boolean separatorPending = false;
        int count = 0;
        for (int i = 0; i < actions.length; ++i) {
            AbstractAction action;
            ActionPlugin actionPlugin = actions[i];
            if (!actionPlugin.isAddToMenu()) continue;
            if (count > 0 && separatorPending) {
                menu.addSeparator();
                separatorPending = false;
            }
            if (actionPlugin instanceof ExportActionPlugin) {
                ExportActionPlugin exportPlugin = (ExportActionPlugin)actionPlugin;
                action = new ExportAction(exportPlugin, pane);
                menu.add(new JMenuItem(action));
                ++count;
            } else if (actionPlugin instanceof ControlActionPlugin) {
                ControlActionPlugin controlPlugin = (ControlActionPlugin)actionPlugin;
                action = new ControlAction(controlPlugin, pane);
                menu.add(new JMenuItem(action));
                ++count;
            } else if (actionPlugin instanceof ZoomListActionPlugin) {
                retval = PreviewPaneUtilities.buildViewMenu(menu, pane);
            }
            if (!actionPlugin.isSeparated()) continue;
            separatorPending = true;
        }
        return retval;
    }

    private static ZoomAction[] buildViewMenu(JMenu zoom, PreviewPane pane) {
        double[] zoomFactors = pane.getZoomFactors();
        ZoomAction[] zoomActions = new ZoomAction[zoomFactors.length];
        for (int i = 0; i < zoomFactors.length; ++i) {
            double factor = zoomFactors[i];
            zoomActions[i] = new ZoomAction(factor, pane);
            zoom.add(new JMenuItem(zoomActions[i]));
        }
        return zoomActions;
    }

    public static void addActionsToToolBar(JToolBar toolBar, ActionPlugin[] reportActions, JComboBox zoomSelector, PreviewPane pane) {
        if (reportActions == null) {
            return;
        }
        boolean separatorPending = false;
        int count = 0;
        for (int i = 0; i < reportActions.length; ++i) {
            AbstractAction action;
            ActionPlugin actionPlugin = reportActions[i];
            if (!actionPlugin.isAddToToolbar()) continue;
            if (count > 0 && separatorPending) {
                toolBar.addSeparator();
                separatorPending = false;
            }
            if (actionPlugin instanceof ExportActionPlugin) {
                ExportActionPlugin exportPlugin = (ExportActionPlugin)actionPlugin;
                action = new ExportAction(exportPlugin, pane);
                toolBar.add(PreviewPaneUtilities.createButton(action, pane.getSwingGuiContext()));
                ++count;
            } else if (actionPlugin instanceof ControlActionPlugin) {
                ControlActionPlugin controlPlugin = (ControlActionPlugin)actionPlugin;
                action = new ControlAction(controlPlugin, pane);
                toolBar.add(PreviewPaneUtilities.createButton(action, pane.getSwingGuiContext()));
                ++count;
            } else if (actionPlugin instanceof ZoomListActionPlugin) {
                ZoomListActionPlugin zoomListActionPlugin = (ZoomListActionPlugin)actionPlugin;
                zoomListActionPlugin.setComponent(zoomSelector);
                JPanel zoomPane = new JPanel();
                zoomPane.setLayout(new FlowLayout(0));
                zoomPane.add(zoomSelector);
                toolBar.add(zoomPane);
                ++count;
            }
            if (!actionPlugin.isSeparated()) continue;
            separatorPending = true;
        }
    }

    private static JButton createButton(Action action, SwingGuiContext swingGuiContext) {
        Object value;
        Icon icon;
        JButton button = new JButton(action);
        boolean needText = true;
        if (PreviewPaneUtilities.isLargeButtonsEnabled(swingGuiContext)) {
            icon = (Icon)action.getValue("Icon24");
            if (icon != null && icon.getIconHeight() > 1 && icon.getIconHeight() > 1) {
                button.setIcon(icon);
                needText = false;
            }
        } else {
            icon = (Icon)action.getValue("SmallIcon");
            if (icon != null && icon.getIconHeight() > 1 && icon.getIconHeight() > 1) {
                button.setIcon(icon);
                needText = false;
            }
        }
        if (needText) {
            value = action.getValue("Name");
            if (value != null) {
                button.setText(String.valueOf(value));
            }
        } else {
            button.setText(null);
        }
        value = button.getAction().getValue("AcceleratorKey");
        if (value instanceof KeyStroke) {
            button.unregisterKeyboardAction((KeyStroke)value);
        }
        return button;
    }

    private static boolean isLargeButtonsEnabled(SwingGuiContext swingGuiContext) {
        Configuration configuration = swingGuiContext.getConfiguration();
        return "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.LargeIcons"));
    }

    public static double getNextZoomOut(double zoom, double[] zoomFactors) {
        if (zoom <= zoomFactors[0]) {
            return zoom * 2.0 / 3.0;
        }
        double largestZoom = zoomFactors[zoomFactors.length - 1];
        if (zoom > largestZoom) {
            double linear = zoom * 2.0 / 3.0;
            if (linear < largestZoom) {
                return largestZoom;
            }
            return linear;
        }
        for (int i = zoomFactors.length - 1; i >= 0; --i) {
            double factor = zoomFactors[i];
            if (!(factor < zoom)) continue;
            return factor;
        }
        return zoom * 2.0 / 3.0;
    }

    public static double getNextZoomIn(double zoom, double[] zoomFactors) {
        double largestZoom = zoomFactors[zoomFactors.length - 1];
        if (zoom >= largestZoom) {
            return zoom * 1.5;
        }
        double smallestZoom = zoomFactors[0];
        if (zoom < smallestZoom) {
            double linear = zoom * 1.5;
            if (linear > smallestZoom) {
                return smallestZoom;
            }
            return linear;
        }
        for (int i = 0; i < zoomFactors.length; ++i) {
            double factor = zoomFactors[i];
            if (!(factor > zoom)) continue;
            return factor;
        }
        return zoom * 1.5;
    }

    public static IconTheme createIconTheme(Configuration config) {
        String themeClass = config.getConfigProperty(ICON_THEME_CONFIG_KEY);
        Object maybeTheme = ObjectUtilities.loadAndInstantiate((String)themeClass, PreviewPane.class, IconTheme.class);
        IconTheme iconTheme = maybeTheme != null ? (IconTheme)maybeTheme : new DefaultIconTheme();
        iconTheme.initialize(config);
        return iconTheme;
    }

    public static ActionFactory createActionFactory(Configuration config) {
        String factoryClass = config.getConfigProperty(ACTION_FACTORY_CONFIG_KEY);
        Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)factoryClass, PreviewPane.class, ActionFactory.class);
        ActionFactory actionFactory = maybeFactory != null ? (ActionFactory)maybeFactory : new DefaultActionFactory();
        return actionFactory;
    }

    public static CategoryTreeItem[] buildMenuTree(ActionCategory[] categories) {
        CategoryTreeItem item;
        int j;
        CategoryTreeItem[] tree = new CategoryTreeItem[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            ActionCategory category = categories[i];
            tree[i] = new CategoryTreeItem(category);
        }
        for (j = 0; j < tree.length; ++j) {
            item = tree[j];
            String itemName = item.getName();
            int parentWeight = 0;
            CategoryTreeItem parent = null;
            for (int k = 0; k < tree.length; ++k) {
                CategoryTreeItem treeItem;
                String parentName;
                if (k == j || !itemName.startsWith(parentName = (treeItem = tree[k]).getName()) || parentName.length() <= parentWeight) continue;
                parent = treeItem;
                parentWeight = parentName.length();
            }
            item.setParent(parent);
        }
        for (j = 0; j < tree.length; ++j) {
            item = tree[j];
            CategoryTreeItem parent = item.getParent();
            if (parent == null) continue;
            parent.add(item);
        }
        return tree;
    }

    public static Map<ActionCategory, ActionPlugin[]> loadActions(SwingGuiContext swingGuiContext) {
        HashMap<ActionCategory, ActionPlugin[]> actions = new HashMap<ActionCategory, ActionPlugin[]>();
        Configuration configuration = swingGuiContext.getConfiguration();
        ActionCategory[] categories = PreviewPaneUtilities.loadCategories(swingGuiContext);
        ActionFactory factory = PreviewPaneUtilities.createActionFactory(configuration);
        for (int i = 0; i < categories.length; ++i) {
            ActionCategory category = categories[i];
            actions.put(category, factory.getActions(swingGuiContext, category.getName()));
        }
        return actions;
    }

    public static ActionCategory[] loadCategories(SwingGuiContext swingGuiContext) {
        ArrayList<ActionCategory> categories = new ArrayList<ActionCategory>();
        Configuration configuration = swingGuiContext.getConfiguration();
        Iterator keys = configuration.findPropertyKeys(CATEGORY_PREFIX);
        while (keys.hasNext()) {
            ActionCategory actionCategory;
            String base;
            String enableKey = (String)keys.next();
            if (!enableKey.endsWith(".enabled") || !"true".equals(configuration.getConfigProperty(enableKey)) || (base = enableKey.substring(0, enableKey.length() - ".enabled".length())).length() == 0) continue;
            String categoryKey = base.substring(CATEGORY_PREFIX.length());
            String className = configuration.getConfigProperty(base + ".class");
            if (className == null) {
                actionCategory = new ActionCategory();
            } else {
                actionCategory = (ActionCategory)ObjectUtilities.loadAndInstantiate((String)className, PreviewPane.class, ActionCategory.class);
                if (actionCategory == null) {
                    actionCategory = new ActionCategory();
                }
            }
            String positionText = configuration.getConfigProperty(base + ".position");
            actionCategory.setPosition(ParserUtil.parseInt((String)positionText, (int)0));
            actionCategory.setName(categoryKey);
            actionCategory.setResourceBase(configuration.getConfigProperty(base + ".resource-base"));
            actionCategory.setResourcePrefix(configuration.getConfigProperty(base + ".resource-prefix"));
            actionCategory.initialize(swingGuiContext);
            categories.add(actionCategory);
        }
        return categories.toArray(new ActionCategory[categories.size()]);
    }
}

